# HelpDesk – SPEC

Documento de referência que consolida conceitos funcionais e padrões técnicos do sistema HelpDesk.

## Visão Geral do Sistema

O HelpDesk centraliza o ciclo de vida dos chamados de suporte gerados por clientes internos e externos, permitindo registro estruturado, classificação por filas, monitoramento de SLA, comunicação em timeline e gestão de anexos. O backend expõe APIs REST em PHP (framework interno) e o frontend web consome esses serviços para que atendentes e gestores acompanhem os tickets em tempo real.

## Atores e Responsabilidades

| Ator      | Tipo      | Responsabilidades principais |
|-----------|-----------|------------------------------|
| Interno   | Usuário   | Cria chamados a partir de solicitações da organização, consulta status e complementa informações. |
| Externo   | Usuário   | Abre chamados relacionados a contratos/serviços ativos, acompanha andamento e envia anexos. |
| Atendente | Operador  | Triagem, atualização de status, interação via timeline, coleta de evidências e execução de SLA. |
| Gestor    | Supervisor| Configura filas, distribui carga, ajusta SLAs e monitora KPIs e violações. |

## RBAC (Role-Based Access Control)

| Recurso / Ação                  | Interno | Externo | Atendente | Gestor |
|---------------------------------|---------|---------|-----------|--------|
| Criar chamado                   | ✅      | ✅      | ✅        | ✅     |
| Editar chamado aberto           | ✳️ (autor) | ✳️ (autor) | ✅        | ✅     |
| Reatribuir fila                 | ❌      | ❌      | ✅        | ✅     |
| Atualizar status                | ❌      | ❌      | ✅        | ✅     |
| Pausar/retomar SLA              | ❌      | ❌      | ✅        | ✅     |
| Gerenciar usuários/funções      | ❌      | ❌      | ❌        | ✅     |
| Configurar regras de SLA        | ❌      | ❌      | ❌        | ✅     |
| Visualizar todos os chamados    | ❌      | ❌      | ✅        | ✅     |
| Visualizar relatórios/KPIs      | ❌      | ❌      | 🚫 (próprias filas) | ✅ |

Legenda: ✅ acesso total, ✳️ acesso restrito ao chamado criado, ❌ sem acesso, 🚫 acesso limitado por fila.

## Status do Chamado

1. **Novo** – chamado registrado e aguardando triagem inicial.  
2. **Em Triagem** – atendente avalia dados, define fila e prioridade.  
3. **Em Atendimento** – execução ativa de ações técnicas e comunicação com o solicitante.  
4. **Aguardando Cliente** – bloqueado por falta de informação do solicitante.  
5. **Pausado Interno** – parado por dependência interna (ex.: outra equipe).  
6. **Resolvido** – solução aplicada e aguardando validação do solicitante.  
7. **Fechado** – solução aceita ou encerramento manual.  
8. **Cancelado** – chamado inválido ou duplicado.

Transições devem seguir fluxo configurado: `Novo → Em Triagem → Em Atendimento → (Aguardando Cliente | Pausado Interno | Resolvido | Cancelado)` e somente gestores podem reabrir chamados fechados.

## Regras de SLA (Contagem e Pausa)

- **Contagem padrão**: inicia ao sair de `Novo`, contabiliza minutos úteis seguindo o calendário da conta (configurável por Gestor), considerando somente janelas de atendimento.  
- **Pausa automática**: status `Aguardando Cliente` suspende o relógio até que o solicitante interaja ou o atendente retorne o chamado para `Em Atendimento`.  
- **Pausa manual**: atendentes e gestores podem definir `Pausado Interno` justificando o motivo; o SLA fica congelado e gera auditoria.  
- **Retomada**: ao voltar para `Em Atendimento`, retoma-se o tempo restante.  
- **Violação**: ao ultrapassar o prazo, gera evento de SLA violado, notifica gestor e muda indicador visual do chamado.  
- **Multi-SLA**: cada fila pode ter SLA próprio (ex.: resposta inicial, resolução). Ambos seguem as mesmas regras de pausa/retomada.

## Padrões de Código

- **PHP Standards**: seguir PSR-12 (indentação 4 espaços, namespaces obrigatórios, importações agrupadas, limites de linha respeitados).  
- **Naming**: classes e arquivos em `PascalCase`, métodos em `camelCase`, constantes em `UPPER_SNAKE_CASE`, rotas REST no padrão `kebab-case`.  
- **Arquitetura**: estrutura MVC.  
  - `app/Models` – entidades e regras de domínio.  
  - `app/Controllers` – coordenação de requisições HTTP e orquestração de serviços.  
  - `app/Views` – templates Blade/Twig (ou similar) para renderização.  
  - `routes/` – definição explícita de endpoints, sempre apontando para controllers.  
  - `resources/` – assets compartilhados (componentes Vue/React, traduções).  
- **Boas práticas adicionais**: validação com Form Requests, respostas API padronizadas em JSON (`data`, `meta`, `errors`), testes automáticos (PHPUnit/Pest) para fluxos críticos de SLA e RBAC.

## Mini Glossário

- **Chamado**: registro individual de solicitação de suporte, identificado por número único.  
- **Fila**: agrupamento lógico de chamados alinhado a equipes/competências.  
- **SLA**: acordo de nível de serviço que define prazos de resposta e resolução.  
- **Timeline**: histórico cronológico de interações, transições e notificações do chamado.  
- **Anexos**: arquivos associados ao chamado (prints, logs, documentos) com versionamento básico e controle de acesso.
