<?php
declare(strict_types=1);

namespace App\Config;

/**
 * Centralized application configuration.
 */
final class AppConfig
{
    private const TIMEZONE = 'America/Sao_Paulo';
    private const DEBUG = true;
    private const INSTALLER_PASSWORD = 'helpdesk2025';
    private const SSO_SECRET = 'intranet_shared_secret_2025';
    private const SSO_TOKEN_TTL = 300; // seconds
    private const SSO_ALLOWED_DRIFT = 30; // seconds
    private const TICKET_REOPEN_DAYS = 7;
    private const AUTO_CLOSE_RESOLVED_HOURS = 72;

    private static bool $initialized = false;

    public static function init(): void
    {
        if (!self::$initialized) {
            date_default_timezone_set(self::TIMEZONE);
            self::$initialized = true;
        }
    }

    public static function timezone(): string
    {
        self::init();
        return self::TIMEZONE;
    }

    public static function isDebug(): bool
    {
        self::init();
        return self::DEBUG;
    }

    public static function installerPassword(): string
    {
        return self::INSTALLER_PASSWORD;
    }

    public static function ssoSecret(): string
    {
        return self::SSO_SECRET;
    }

    public static function ssoTokenTtl(): int
    {
        return self::SSO_TOKEN_TTL;
    }

    public static function ssoAllowedDrift(): int
    {
        return self::SSO_ALLOWED_DRIFT;
    }

    public static function ticketReopenDays(): int
    {
        return self::TICKET_REOPEN_DAYS;
    }

    public static function autoCloseResolvedHours(): int
    {
        return self::AUTO_CLOSE_RESOLVED_HOURS;
    }
}

AppConfig::init();
