<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Services\AuthService;

final class DashboardController extends Controller
{
    public function __construct(
        private readonly AuthService $authService
    ) {
    }

    public function index(): string
    {
        $user = $this->authService->user();

        $heroStats = [
            ['label' => 'Tickets abertos', 'value' => '42', 'badge' => 'Hoje'],
            ['label' => 'SLA em risco', 'value' => '5', 'badge' => '4h restantes'],
            ['label' => 'Feedbacks positivos', 'value' => '97%', 'badge' => 'Este mês'],
        ];

        $ticketsPreview = [
            ['reference' => 'HDK-0001', 'subject' => 'Acesso VPN instável', 'status' => 'Em Atendimento', 'priority' => 'Alta'],
            ['reference' => 'HDK-0002', 'subject' => 'Notebook sem acesso ao ERP', 'status' => 'Em Triagem', 'priority' => 'Normal'],
            ['reference' => 'HDK-0003', 'subject' => 'Atualização de certificado', 'status' => 'Novo', 'priority' => 'Baixa'],
        ];

        return $this->render('dashboard/index', [
            'user' => $user,
            'heroStats' => $heroStats,
            'ticketsPreview' => $ticketsPreview,
            'pageTitle' => 'Dashboard',
        ]);
    }
}
