<?php
declare(strict_types=1);

namespace App\Middlewares;

use App\Services\AuthService;

final class PermissionMiddleware
{
    public function __construct(
        private readonly AuthService $authService
    ) {
    }

    /**
     * @param string[] $allowedRoles
     * @param array<string, mixed> $context
     */
    public function handle(array $allowedRoles = [], ?string $ability = null, array $context = []): void
    {
        if ($ability !== null) {
            if (\can($ability, $context)) {
                return;
            }

            $this->deny();
        }

        if ($allowedRoles === [] || $this->authService->hasRole($allowedRoles)) {
            return;
        }

        $this->deny();
    }

    private function deny(): void
    {
        http_response_code(403);
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode([
            'error' => 'Forbidden',
            'message' => 'Usuario sem permissao para acessar este recurso.',
        ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        exit;
    }
}
