<?php
declare(strict_types=1);

namespace App\Repositories;

use App\Config\Database;
use PDO;

final class LookupRepository
{
    /**
     * @return array<int, array<string, mixed>>
     */
    public function statuses(): array
    {
        $sql = 'SELECT id, name, slug FROM statuses ORDER BY id ASC';
        $statement = Database::run($sql);

        return $statement->fetchAll(PDO::FETCH_ASSOC) ?: [];
    }

    /**
     * @return array<int, array<string, mixed>>
     */
    public function priorities(): array
    {
        $sql = 'SELECT id, name, slug, color FROM priorities ORDER BY sort_order ASC, id ASC';
        $statement = Database::run($sql);

        return $statement->fetchAll(PDO::FETCH_ASSOC) ?: [];
    }

    /**
     * @return array<int, array<string, mixed>>
     */
    public function queues(): array
    {
        $sql = 'SELECT id, name, slug FROM queues WHERE is_active = 1 ORDER BY name ASC';
        $statement = Database::run($sql);

        return $statement->fetchAll(PDO::FETCH_ASSOC) ?: [];
    }

    /**
     * @return array<int, array<string, mixed>>
     */
    public function categories(): array
    {
        $sql = 'SELECT id, name, slug, queue_id FROM categories ORDER BY name ASC';
        $statement = Database::run($sql);

        return $statement->fetchAll(PDO::FETCH_ASSOC) ?: [];
    }

    /**
     * @return array<int, array<string, mixed>>
     */
    public function activeUsers(): array
    {
        $sql = <<<SQL
            SELECT
                u.id,
                u.name,
                u.email,
                u.role_id,
                u.queue_id,
                u.is_active,
                r.name AS role_name
            FROM users u
            INNER JOIN roles r ON r.id = u.role_id
            WHERE u.deleted_at IS NULL
            ORDER BY u.name ASC
        SQL;

        $statement = Database::run($sql);

        return $statement->fetchAll(PDO::FETCH_ASSOC) ?: [];
    }
}
