<?php
declare(strict_types=1);

namespace App\Repositories;

use App\Config\Database;
use PDO;

final class RoleRepository
{
    /**
     * @return array<int, array<string, mixed>>
     */
    public function all(): array
    {
        $statement = Database::run('SELECT id, slug, name FROM roles ORDER BY id ASC');
        return $statement->fetchAll(PDO::FETCH_ASSOC) ?: [];
    }
}
