<?php
$flashMessage = $flash['success'] ?? null;
$errors = $errors ?? [];
$categories = $categories ?? [];
$filters = $filters ?? ['q' => '', 'status' => 'all'];
$pagination = $pagination ?? ['page' => 1, 'pages' => 1, 'total' => 0];
$adminSection = $adminSection ?? 'categories';

$queryBase = [];
if (!empty($filters['q'])) {
    $queryBase['q'] = $filters['q'];
}
if (!empty($filters['status']) && $filters['status'] !== 'all') {
    $queryBase['status'] = $filters['status'];
}

$buildUrl = static function (array $baseQuery, int $page): string {
    if ($page > 1) {
        $baseQuery['page'] = $page;
    } else {
        unset($baseQuery['page']);
    }

    $queryString = http_build_query($baseQuery);
    $suffix = $queryString !== '' ? '?' . $queryString : '';

    return app_url('admin/categories' . $suffix);
};

$currentPage = max(1, (int) ($pagination['page'] ?? 1));
$currentRedirect = $buildUrl($queryBase, $currentPage);
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Administração</p>
            <h1 class="page__title">Categorias</h1>
            <p class="page__subtitle">Organize o catálogo de atendimento com hierarquia e filas padrão.</p>
        </div>
        <div>
            <a class="btn" href="<?= htmlspecialchars(app_url('admin/categories/create'), ENT_QUOTES, 'UTF-8'); ?>">Nova categoria</a>
        </div>
    </div>
    <?php include APP_PATH . '/Views/admin/nav.php'; ?>

    <?php if ($flashMessage): ?>
        <div class="alert alert--info"><?= htmlspecialchars($flashMessage, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>
    <?php if (!empty($errors)): ?>
        <div class="alert alert--error">
            <?php foreach ($errors as $error): ?>
                <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <div class="card__title">Filtros</div>
        <form method="get" action="<?= htmlspecialchars(app_url('admin/categories'), ENT_QUOTES, 'UTF-8'); ?>" class="form-grid" style="align-items:flex-end;">
            <div>
                <label class="input-label" for="filter-q">Buscar</label>
                <input class="input-control" id="filter-q" name="q" value="<?= htmlspecialchars($filters['q'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" placeholder="Nome ou slug da categoria">
            </div>
            <div>
                <label class="input-label" for="filter-status">Status</label>
                <select class="select-control" id="filter-status" name="status">
                    <option value="all"<?= ($filters['status'] ?? 'all') === 'all' ? ' selected' : ''; ?>>Todos</option>
                    <option value="active"<?= ($filters['status'] ?? 'all') === 'active' ? ' selected' : ''; ?>>Ativos</option>
                    <option value="inactive"<?= ($filters['status'] ?? 'all') === 'inactive' ? ' selected' : ''; ?>>Inativos</option>
                </select>
            </div>
            <div style="align-self:flex-end;">
                <button class="btn" type="submit">Filtrar</button>
            </div>
        </form>
    </div>

    <div class="card">
        <div class="card__title">Categorias cadastradas</div>
        <div class="data-table__wrapper">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Slug</th>
                        <th>Categoria pai</th>
                        <th>Fila padrão</th>
                        <th>Ordem</th>
                        <th>Status</th>
                        <th style="width:220px;">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($categories as $category): ?>
                        <?php
                            $isActive = (int) ($category['is_active'] ?? 0) === 1;
                            $toggleLabel = $isActive ? 'Inativar' : 'Ativar';
                            $toggleValue = $isActive ? 0 : 1;
                        ?>
                        <tr>
                            <td><?= htmlspecialchars($category['name'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><code><?= htmlspecialchars($category['slug'] ?? '', ENT_QUOTES, 'UTF-8'); ?></code></td>
                            <td><?= htmlspecialchars($category['parent_name'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?= htmlspecialchars($category['queue_name'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?= (int) ($category['sort_order'] ?? 0); ?></td>
                            <td>
                                <span class="badge <?= $isActive ? 'badge--success' : 'badge--secondary'; ?>">
                                    <?= $isActive ? 'Ativa' : 'Inativa'; ?>
                                </span>
                            </td>
                            <td style="display:flex;gap:0.35rem;flex-wrap:wrap;">
                                <a class="btn btn--sm btn--outline" href="<?= htmlspecialchars(app_url('admin/categories/edit?id=' . (int) $category['id']), ENT_QUOTES, 'UTF-8'); ?>">Editar</a>
                                <form method="post" action="<?= htmlspecialchars(app_url('admin/categories/toggle?id=' . (int) $category['id']), ENT_QUOTES, 'UTF-8'); ?>">
                                    <?= csrf_input(); ?>
                                    <input type="hidden" name="status" value="<?= $toggleValue; ?>">
                                    <input type="hidden" name="redirect" value="<?= htmlspecialchars('admin/categories' . (strpos($currentRedirect, '?') !== false ? substr($currentRedirect, strpos($currentRedirect, '?')) : ''), ENT_QUOTES, 'UTF-8'); ?>">
                                    <button class="btn btn--sm btn--ghost" type="submit"><?= htmlspecialchars($toggleLabel, ENT_QUOTES, 'UTF-8'); ?></button>
                                </form>
                                <a class="btn btn--sm btn--ghost" href="<?= htmlspecialchars(app_url('admin/categories/delete?id=' . (int) $category['id']), ENT_QUOTES, 'UTF-8'); ?>">Excluir</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (empty($categories)): ?>
                        <tr>
                            <td colspan="7" style="text-align:center;padding:1rem;">Nenhuma categoria encontrada.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <?php if (($pagination['pages'] ?? 1) > 1): ?>
            <nav class="pagination">
                <?php if ($currentPage > 1): ?>
                    <a class="pagination__link" href="<?= htmlspecialchars($buildUrl($queryBase, $currentPage - 1), ENT_QUOTES, 'UTF-8'); ?>">&laquo; Anterior</a>
                <?php endif; ?>
                <span class="pagination__current">Página <?= (int) $currentPage; ?> de <?= (int) ($pagination['pages'] ?? 1); ?></span>
                <?php if ($currentPage < ($pagination['pages'] ?? 1)): ?>
                    <a class="pagination__link" href="<?= htmlspecialchars($buildUrl($queryBase, $currentPage + 1), ENT_QUOTES, 'UTF-8'); ?>">Próxima &raquo;</a>
                <?php endif; ?>
            </nav>
        <?php endif; ?>
    </div>
</section>
