<?php
$flashMessage = $flash['success'] ?? null;
$errors = $errors ?? [];
$adminSection = $adminSection ?? 'fields';
$fieldRecord = $fieldRecord ?? null;
$fieldId = (int) ($fieldRecord['id'] ?? 0);
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Administração</p>
            <h1 class="page__title">Excluir campo</h1>
            <p class="page__subtitle">Esta ação remove o campo e seus valores associados.</p>
        </div>
        <div>
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/fields'), ENT_QUOTES, 'UTF-8'); ?>">Voltar para a lista</a>
        </div>
    </div>
    <?php include APP_PATH . '/Views/admin/nav.php'; ?>

    <?php if ($flashMessage): ?>
        <div class="alert alert--info"><?= htmlspecialchars($flashMessage, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>
    <?php if (!empty($errors)): ?>
        <div class="alert alert--error">
            <?php foreach ($errors as $error): ?>
                <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <h2 class="card__title">Confirmar exclusão</h2>
        <p>Você está prestes a remover o campo <strong><?= htmlspecialchars($fieldRecord['label'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></strong> (<?= htmlspecialchars($fieldRecord['name'] ?? '', ENT_QUOTES, 'UTF-8'); ?>) da categoria <strong><?= htmlspecialchars($fieldRecord['category_name'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></strong>.</p>
        <p class="muted">Todos os valores associados a tickets também serão removidos. Esta ação não pode ser desfeita.</p>
        <form method="post" action="<?= htmlspecialchars(app_url('admin/fields/delete?id=' . $fieldId), ENT_QUOTES, 'UTF-8'); ?>" style="display:flex;gap:0.5rem;flex-wrap:wrap;">
            <?= csrf_input(); ?>
            <button class="btn btn--outline" type="submit">Excluir campo</button>
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/fields'), ENT_QUOTES, 'UTF-8'); ?>">Cancelar</a>
        </form>
    </div>
</section>
