<?php
$adminSection = $adminSection ?? 'categories';
$items = [
    ['section' => 'categories', 'label' => 'Categorias / Subcategorias', 'url' => app_url('admin/categories')],
    ['section' => 'queues', 'label' => 'Filas', 'url' => app_url('admin/queues')],
    ['section' => 'fields', 'label' => 'Campos dinâmicos', 'url' => app_url('admin/fields')],
    ['section' => 'sla', 'label' => 'Políticas de SLA', 'url' => app_url('admin/slas')],
    ['section' => 'theme', 'label' => 'Tema e Branding', 'url' => app_url('admin/theme')],
    ['section' => 'users', 'label' => 'Usuários e permissões', 'url' => app_url('admin/users')],
];
?>
<nav class="admin-nav">
    <?php foreach ($items as $item): ?>
        <a class="admin-nav__link<?= $adminSection === $item['section'] ? ' is-active' : ''; ?>"
           href="<?= htmlspecialchars($item['url'], ENT_QUOTES, 'UTF-8'); ?>">
            <?= htmlspecialchars($item['label'], ENT_QUOTES, 'UTF-8'); ?>
        </a>
    <?php endforeach; ?>
 </nav>
