<?php
$flashMessage = $flash['success'] ?? null;
$errors = $errors ?? [];
$adminSection = $adminSection ?? 'sla';
$slaRecord = $slaRecord ?? null;
if ($slaRecord === null) {
    $slaRecord = ['name' => '-', 'id' => 0];
}
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Administração</p>
            <h1 class="page__title">Excluir SLA</h1>
            <p class="page__subtitle">Confirme para remover o SLA selecionado da lista padrão.</p>
        </div>
        <div>
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/slas'), ENT_QUOTES, 'UTF-8'); ?>">Voltar para a lista</a>
        </div>
    </div>
    <?php include APP_PATH . '/Views/admin/nav.php'; ?>

    <?php if ($flashMessage): ?>
        <div class="alert alert--info"><?= htmlspecialchars($flashMessage, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>
    <?php if (!empty($errors)): ?>
        <div class="alert alert--error">
            <?php foreach ($errors as $error): ?>
                <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <div class="card__title">Confirmação</div>
        <p>Tem certeza que deseja excluir o SLA <strong><?= htmlspecialchars($slaRecord['name'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></strong>? Ele será ocultado das configurações, mas poderá ser recriado posteriormente.</p>
        <form method="post" action="<?= htmlspecialchars(app_url('admin/slas/delete?id=' . (int) ($slaRecord['id'] ?? 0)), ENT_QUOTES, 'UTF-8'); ?>" style="display:flex;gap:0.5rem;flex-wrap:wrap;">
            <?= csrf_input(); ?>
            <button class="btn btn--outline" type="submit">Confirmar exclusão</button>
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/slas'), ENT_QUOTES, 'UTF-8'); ?>">Cancelar</a>
        </form>
    </div>
</section>
