<?php
$pageTitle = $pageTitle ?? 'Chamados';
$statuses = $options['statuses'] ?? [];
$priorities = $options['priorities'] ?? [];
$queues = $options['queues'] ?? [];
$categories = $options['categories'] ?? [];

$flashSuccess = $flash['success'] ?? null;
$flashError = $flash['error'] ?? null;
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Operação</p>
            <h1 class="page__title">Chamados</h1>
            <p class="page__subtitle">Filtre por status, prioridade, fila e período para acompanhar o volume atual.</p>
        </div>
        <div class="page__actions">
            <?php if (\role('atendente-ti', 'atendente-noc')): ?>
                <a class="btn btn--outline" href="<?= htmlspecialchars(app_url('tickets/minha-fila'), ENT_QUOTES, 'UTF-8'); ?>">Minha fila</a>
            <?php endif; ?>
            <?php if (\can('create_ticket')): ?>
                <a class="btn" href="<?= htmlspecialchars(app_url('tickets/create'), ENT_QUOTES, 'UTF-8'); ?>">Novo Chamado</a>
            <?php endif; ?>
        </div>
    </div>

    <?php if ($flashSuccess): ?>
        <div class="alert alert--info" style="background: rgba(33, 150, 83, 0.12); color:#1b5e20; border:1px solid rgba(33,150,83,0.3);">
            <?= htmlspecialchars($flashSuccess, ENT_QUOTES, 'UTF-8'); ?>
        </div>
    <?php endif; ?>
    <?php if ($flashError): ?>
        <div class="alert alert--error"><?= htmlspecialchars($flashError, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>

    <div class="card">
        <form method="get" action="<?= htmlspecialchars(app_url('tickets'), ENT_QUOTES, 'UTF-8'); ?>" class="filters-grid">
            <div>
                <label class="input-label" for="status_id">Status</label>
                <select class="select-control" id="status_id" name="status_id">
                    <option value="">Todos</option>
                    <?php foreach ($statuses as $status): ?>
                        <option value="<?= (int) $status['id']; ?>" <?= ((string)$filters['status_id'] === (string)$status['id']) ? 'selected' : ''; ?>>
                            <?= htmlspecialchars($status['name'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div>
                <label class="input-label" for="priority_id">Prioridade</label>
                <select class="select-control" id="priority_id" name="priority_id">
                    <option value="">Todas</option>
                    <?php foreach ($priorities as $priority): ?>
                        <option value="<?= (int) $priority['id']; ?>" <?= ((string)$filters['priority_id'] === (string)$priority['id']) ? 'selected' : ''; ?>>
                            <?= htmlspecialchars($priority['name'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div>
                <label class="input-label" for="queue_id">Fila</label>
                <select class="select-control" id="queue_id" name="queue_id">
                    <option value="">Todas</option>
                    <?php foreach ($queues as $queue): ?>
                        <option value="<?= (int) $queue['id']; ?>" <?= ((string)$filters['queue_id'] === (string)$queue['id']) ? 'selected' : ''; ?>>
                            <?= htmlspecialchars($queue['name'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div>
                <label class="input-label" for="category_id">Subcategoria</label>
                <select class="select-control" id="category_id" name="category_id">
                    <option value="">Todas</option>
                    <?php foreach ($categories as $category): ?>
                        <option value="<?= (int) $category['id']; ?>" <?= ((string)$filters['category_id'] === (string)$category['id']) ? 'selected' : ''; ?>>
                            <?= htmlspecialchars($category['name'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div>
                <label class="input-label" for="main_category">Categoria principal</label>
                <select class="select-control" id="main_category" name="main_category">
                    <option value="">Todas</option>
                    <option value="ti" <?= $filters['main_category'] === 'ti' ? 'selected' : ''; ?>>TI</option>
                    <option value="noc" <?= $filters['main_category'] === 'noc' ? 'selected' : ''; ?>>NOC</option>
                </select>
            </div>
            <div>
                <label class="input-label" for="from_date">De</label>
                <input class="input-control" type="date" id="from_date" name="from_date" value="<?= htmlspecialchars((string) $filters['from_date'], ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div>
                <label class="input-label" for="to_date">Até</label>
                <input class="input-control" type="date" id="to_date" name="to_date" value="<?= htmlspecialchars((string) $filters['to_date'], ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div style="align-self:flex-end;">
                <button class="btn" type="submit">Filtrar</button>
            </div>
        </form>
    </div>

    <div class="card card--elevated">
        <div style="overflow-x:auto;">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Ref</th>
                        <th>Assunto</th>
                        <th>Fila</th>
                        <th>Status</th>
                        <th>SLA</th>
                        <th>Prioridade</th>
                        <th>Categoria</th>
                        <th>Atualizado</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($tickets as $ticket): ?>
                    <?php $isEmergencyRow = !empty($ticket['is_emergency']); ?>
                    <tr class="<?= $isEmergencyRow ? 'ticket-row ticket-row--emergency' : 'ticket-row'; ?>">
                        <td><?= htmlspecialchars($ticket['reference'], ENT_QUOTES, 'UTF-8'); ?></td>
                        <td>
                            <strong><?= htmlspecialchars($ticket['subject'], ENT_QUOTES, 'UTF-8'); ?></strong><br>
                            <span class="muted"><?= htmlspecialchars($ticket['requester_name'], ENT_QUOTES, 'UTF-8'); ?></span>
                            <?php if ($isEmergencyRow): ?>
                                <span class="badge badge--danger badge--pulse">Emergência</span>
                            <?php endif; ?>
                        </td>
                        <td><?= htmlspecialchars($ticket['queue_name'], ENT_QUOTES, 'UTF-8'); ?></td>
                        <td><span class="badge badge--secondary"><?= htmlspecialchars($ticket['status_name'], ENT_QUOTES, 'UTF-8'); ?></span></td>
                        <td>
                            <?php $slaData = $ticket['sla']['resolution'] ?? null; ?>
                            <?php if ($slaData && ($slaData['target'] ?? 0) > 0): ?>
                                <?php
                                $slaStatus = $slaData['status'] ?? 'pending';
                                $isLate = $slaStatus === 'late';
                                $badgeClass = $isLate ? 'badge badge--danger' : 'badge badge--success';
                                $badgeText = $isLate ? 'Estourado' : 'No prazo';
                                $delta = ($slaData['target'] ?? 0) - ($slaData['elapsed'] ?? 0);
                                $detail = '';
                                if ($isLate) {
                                    $detail = '+' . human_minutes(($slaData['elapsed'] ?? 0) - ($slaData['target'] ?? 0));
                                } elseif ($slaStatus === 'pending') {
                                    $detail = human_minutes(max(0, $delta)) . ' restante';
                                } else {
                                    $detail = human_minutes($slaData['elapsed'] ?? 0) . ' / ' . human_minutes($slaData['target'] ?? 0);
                                }
                                ?>
                                <div class="sla-badge">
                                    <span class="<?= $badgeClass; ?>"><?= $badgeText; ?></span>
                                    <small class="muted"><?= htmlspecialchars($detail, ENT_QUOTES, 'UTF-8'); ?></small>
                                </div>
                            <?php else: ?>
                                <span class="badge badge--neutral">Sem SLA</span>
                            <?php endif; ?>
                        </td>
                        <td><span class="badge badge--primary"><?= htmlspecialchars($ticket['priority_name'], ENT_QUOTES, 'UTF-8'); ?></span></td>
                        <td><?= htmlspecialchars(strtoupper($ticket['main_category']), ENT_QUOTES, 'UTF-8'); ?></td>
                        <td><?= htmlspecialchars(date('d/m H:i', strtotime($ticket['updated_at'])), ENT_QUOTES, 'UTF-8'); ?></td>
                        <td>
                            <a class="btn btn--outline" href="<?= htmlspecialchars(app_url('tickets/show?id=' . $ticket['id']), ENT_QUOTES, 'UTF-8'); ?>">Detalhes</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
                <?php if (empty($tickets)): ?>
                    <tr>
                        <td colspan="9" style="text-align:center;padding:1.5rem;">Nenhum chamado encontrado.</td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</section>
