# Guia de Deploy — HelpDesk Sinarco

## Requisitos de Servidor

- **Sistema Operacional**: Linux 64 bits (Ubuntu 22.04+ ou equivalente).
- **Web Server**: Apache/Nginx com suporte a URL rewriting apontando para `public/`.
- **PHP**: versão 8.2+ com extensões `pdo_mysql`, `mbstring`, `json`, `openssl`, `curl`, `fileinfo`, `session`.
- **MySQL/MariaDB**: MySQL 8.x ou MariaDB 10.6+ com collation `utf8mb4_unicode_ci`.
- **Composer**: não requerido, mas PHP CLI deve estar disponível para cron/instalador.
- **Permissões**: usuário do web server precisa poder escrever nas pastas listadas abaixo.

## Permissões de Pasta

```
/storage/logs
/storage/uploads
/storage/cache
```

Execute após deploy:

```bash
chown -R www-data:www-data storage
chmod -R 775 storage
```

Caso utilize outro usuário (ex.: `apache`), ajuste conforme necessário. Os diretórios são usados para logs, uploads anexados e cache do SSO.

## Configuração do Banco

1. Crie o banco `helpdesk_sinarco` com `utf8mb4_unicode_ci`.
2. Ajuste `app/Config/database.php` se os dados de acesso diferirem de `root:root@localhost:3306`.
3. Rode o instalador: `http://seu-dominio/public/install.php` com senha `helpdesk2025`. Isso executa `database/schema.sql` + `database/seed.sql`.

## Cron / Worker de E-mail

O worker que envia a fila `notification_outbox` está em `public/cron_send_notifications.php`.

Exemplo de agendamento (a cada 5 minutos):

```
*/5 * * * * /usr/bin/php /var/www/helpdesk/public/cron_send_notifications.php >> /var/www/helpdesk/storage/logs/cron.log 2>&1
```

Checklist do cron:

- Usar o PHP CLI da mesma versão do servidor Web.
- Garantir permissões de escrita em `storage/logs/cron.log`.
- Monitorar o log para erros de SMTP ou autenticação.

## Checklist de Produção

- [ ] Configurar virtual host apontando para `public/` e habilitar HTTPS.
- [ ] Ajustar `app/Config/app.php` (`DEBUG = false`, `SSO_SECRET` conforme intranet).
- [ ] Garantir permissões das pastas `storage/*`.
- [ ] Executar instalador (`install.php`) e remover/renomear após uso.
- [ ] Criar usuário gestor via painel Admin.
- [ ] Configurar filas, SLAs e temas antes da abertura.
- [ ] Configurar cron do worker de e-mail.
- [ ] Validar `/health` (JSON) e `/status` (HTML) retornando `200`.
- [ ] Configurar backup diário do banco + `storage/uploads`.
- [ ] Habilitar logs do servidor e monitorar `storage/logs/app.log`.
- [ ] Registrar o endpoint `/sso` na intranet corporativa.

## Integração com a Intranet (SSO)

O SSO utiliza token assinado por HMAC (`sha256`). O fluxo:

1. A intranet monta um payload JSON com:
   ```json
   {
     "email": "usuario@empresa.com",
     "expires": 1734470400,
     "nonce": "uuid-v4-ou-string-unica"
   }
   ```
2. Codifica o JSON em Base64 URL-safe.
3. Calcula a assinatura `HMAC-SHA256` usando o segredo configurado em `AppConfig::ssoSecret()`.
4. Monta o token `payload.assinatura`.
5. Redireciona o usuário para:  
   `https://helpdesk.exemplo.com/public/sso?token={token}&redirect=/dashboard`

**Restrições importantes**

- `expires`: timestamp Unix (segundos) com TTL máximo de `AppConfig::ssoTokenTtl()` (padrão 300s) e tolerância de drift `AppConfig::ssoAllowedDrift()` (30s).
- `nonce`: obrigatório para evitar replay e só pode ser usado uma vez. O HelpDesk armazena hash em `storage/cache/sso_tokens.json`.
- Emails devem existir e estar ativos na base (usuário autenticado automaticamente).

**Fallback**: caso o token seja inválido ou expire, o usuário é redirecionado para `/login`.

## Página de Status

- `/status`: página HTML com diagnóstico (banco, fila de notificações, permissões).
- `/health`: endpoint JSON (útil para monitor externo).

Ambos podem ser integrados a ferramentas de monitoramento (UptimeRobot, Zabbix etc).
