<?php
declare(strict_types=1);

namespace App\Controllers;

use RuntimeException;

abstract class Controller
{
    protected function render(string $view, array $data = [], ?string $layout = 'layouts/main'): string
    {
        $viewPath = APP_PATH . '/Views/' . $view . '.php';

        if (!file_exists($viewPath)) {
            throw new RuntimeException('View nao encontrada: ' . $view);
        }

        extract($data, EXTR_OVERWRITE);
        ob_start();
        require $viewPath;

        $viewContent = (string) ob_get_clean();

        if ($layout === null) {
            return $viewContent;
        }

        $layoutPath = APP_PATH . '/Views/' . $layout . '.php';
        if (!file_exists($layoutPath)) {
            return $viewContent;
        }

        ob_start();
        require $layoutPath;

        return (string) ob_get_clean();
    }
}
