<?php
declare(strict_types=1);

use RuntimeException;

function csrf_token(): string
{
    if (!isset($_SESSION['_csrf_token']) || !is_string($_SESSION['_csrf_token'])) {
        $_SESSION['_csrf_token'] = bin2hex(random_bytes(32));
    }

    return $_SESSION['_csrf_token'];
}

function csrf_input(): string
{
    $token = htmlspecialchars(csrf_token(), ENT_QUOTES, 'UTF-8');
    return '<input type="hidden" name="_token" value="' . $token . '">';
}

/**
 * @throws RuntimeException
 */
function csrf_validate(): void
{
    $token = $_POST['_token'] ?? '';
    if (!is_string($token) || $token === '') {
        throw new RuntimeException('Sessão expirada. Recarregue a página e tente novamente.');
    }

    if (!hash_equals(csrf_token(), $token)) {
        throw new RuntimeException('Token de segurança inválido. Recarregue a página e tente novamente.');
    }
}
