<?php
declare(strict_types=1);

function theme_variables(): array
{
    return $GLOBALS['app.theme_variables'] ?? [
        '--primary' => '#ff7a18',
        '--secondary' => '#6c63ff',
        '--dark' => '#1f1f1f',
        '--accent' => '#37474f',
        '--bg' => '#f7f8fb',
        '--surface' => '#ffffff',
        '--text' => '#1f1f1f',
    ];
}

function theme_brand(): string
{
    return $GLOBALS['app.theme_brand'] ?? 'HelpDesk';
}

function theme_logo_url(): ?string
{
    $path = $GLOBALS['app.theme_logo'] ?? null;
    if ($path === null || $path === '') {
        return null;
    }

    return asset_url($path);
}
