<?php
declare(strict_types=1);

function human_minutes(int $minutes): string
{
    $minutes = (int) round($minutes);
    $sign = $minutes < 0 ? '-' : '';
    $abs = abs($minutes);
    $hours = (int) floor($abs / 60);
    $remaining = $abs % 60;
    $parts = [];

    if ($hours > 0) {
        $parts[] = $hours . 'h';
    }

    if ($remaining > 0 || $parts === []) {
        $parts[] = $remaining . 'm';
    }

    return $sign . implode(' ', $parts);
}
