<?php
declare(strict_types=1);

namespace App\Repositories;

use App\Config\Database;
use PDO;

final class PriorityRepository
{
    public function findById(int $id): ?array
    {
        $sql = <<<SQL
            SELECT id, slug, name, response_target_minutes, resolution_target_minutes
            FROM priorities
            WHERE id = :id
            LIMIT 1
        SQL;

        $statement = Database::run($sql, ['id' => $id]);
        $row = $statement->fetch(PDO::FETCH_ASSOC);

        return $row === false ? null : $row;
    }

    /**
     * @return array<int, array<string, mixed>>
     */
    public function all(): array
    {
        $sql = 'SELECT id, name, slug FROM priorities ORDER BY sort_order ASC, id ASC';
        $statement = Database::run($sql);

        return $statement->fetchAll(PDO::FETCH_ASSOC) ?: [];
    }
}
