<?php
$flashMessage = $flash['success'] ?? null;
$errors = $errors ?? [];
$adminSection = $adminSection ?? 'fields';
$old = $old ?? [];
$fieldRecord = $fieldRecord ?? null;
$formTitle = $formTitle ?? 'Novo campo';
$formAction = $formAction ?? app_url('admin/fields/store');
$isEdit = $isEdit ?? false;
$categories = $categories ?? [];

$formData = $fieldRecord !== null ? $fieldRecord : [];
$optionsText = '';

if (!empty($old)) {
    $optionsText = (string) ($old['options'] ?? '');
    $formData = array_merge($formData, $old);
} elseif (isset($formData['options'])) {
    $decoded = json_decode((string) $formData['options'], true);
    if (is_array($decoded)) {
        $optionsText = implode("\n", array_map('strval', $decoded));
    }
}

$selectedType = (string) ($formData['type'] ?? 'text');
$isRequired = array_key_exists('is_required', $formData)
    ? (int) $formData['is_required'] === 1
    : false;
$isActive = array_key_exists('is_active', $formData)
    ? (int) $formData['is_active'] === 1
    : true;
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Administração</p>
            <h1 class="page__title"><?= htmlspecialchars($formTitle, ENT_QUOTES, 'UTF-8'); ?></h1>
            <p class="page__subtitle"><?= $isEdit ? 'Atualize definições do campo selecionado.' : 'Cadastre um novo campo dinâmico para os formulários.'; ?></p>
        </div>
        <div>
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/fields'), ENT_QUOTES, 'UTF-8'); ?>">Voltar para a lista</a>
        </div>
    </div>
    <?php include APP_PATH . '/Views/admin/nav.php'; ?>

    <?php if ($flashMessage): ?>
        <div class="alert alert--info"><?= htmlspecialchars($flashMessage, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>
    <?php if (!empty($errors)): ?>
        <div class="alert alert--error">
            <?php foreach ($errors as $error): ?>
                <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <div class="card__title"><?= htmlspecialchars($formTitle, ENT_QUOTES, 'UTF-8'); ?></div>
        <form method="post" action="<?= htmlspecialchars($formAction, ENT_QUOTES, 'UTF-8'); ?>" class="form-grid">
            <?= csrf_input(); ?>
            <div>
                <label class="input-label" for="field-category">Subcategoria</label>
                <select class="select-control" id="field-category" name="category_id" required>
                    <option value="">Selecione</option>
                    <?php foreach ($categories as $category): ?>
                        <option value="<?= (int) $category['id']; ?>"<?= (int) ($formData['category_id'] ?? 0) === (int) $category['id'] ? ' selected' : ''; ?>>
                            <?= htmlspecialchars($category['name'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div>
                <label class="input-label" for="field-label">Rótulo</label>
                <input class="input-control" id="field-label" name="label" required minlength="3" value="<?= htmlspecialchars($formData['label'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div>
                <label class="input-label" for="field-name">Nome técnico</label>
                <input class="input-control" id="field-name" name="name" required minlength="3" placeholder="Ex: software_sistema" value="<?= htmlspecialchars($formData['name'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div>
                <label class="input-label" for="field-type">Tipo</label>
                <select class="select-control" id="field-type" name="type" required>
                    <option value="text"<?= $selectedType === 'text' ? ' selected' : ''; ?>>Texto</option>
                    <option value="textarea"<?= $selectedType === 'textarea' ? ' selected' : ''; ?>>Texto longo</option>
                    <option value="number"<?= $selectedType === 'number' ? ' selected' : ''; ?>>Número</option>
                    <option value="boolean"<?= $selectedType === 'boolean' ? ' selected' : ''; ?>>Sim/Não</option>
                    <option value="select"<?= $selectedType === 'select' ? ' selected' : ''; ?>>Lista</option>
                </select>
            </div>
            <div data-field-options style="grid-column:1 / -1;">
                <label class="input-label" for="field-options">Opções (uma por linha)</label>
                <textarea class="textarea-control" id="field-options" name="options" rows="4" placeholder="Valor 1&#10;Valor 2"><?= htmlspecialchars($optionsText, ENT_QUOTES, 'UTF-8'); ?></textarea>
                <small class="muted">Obrigatório apenas quando o tipo for "Lista".</small>
            </div>
            <div>
                <label class="input-label" for="field-order">Ordem</label>
                <input class="input-control" id="field-order" type="number" name="sort_order" min="0" value="<?= htmlspecialchars((string) ($formData['sort_order'] ?? 0), ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <label class="checkbox-control" style="margin-top:0.5rem;">
                <input type="checkbox" name="is_required" value="1"<?= $isRequired ? ' checked' : ''; ?>>
                <span>Campo obrigatório</span>
            </label>
            <label class="checkbox-control" style="margin-top:0.5rem;">
                <input type="checkbox" name="is_active" value="1"<?= $isActive ? ' checked' : ''; ?>>
                <span>Campo ativo</span>
            </label>
            <div style="align-self:flex-end;">
                <button class="btn" type="submit"><?= $isEdit ? 'Salvar alterações' : 'Criar campo'; ?></button>
            </div>
        </form>
    </div>
</section>
<script>
(function () {
    const typeSelect = document.getElementById('field-type');
    const optionsWrapper = document.querySelector('[data-field-options]');
    if (!typeSelect || !optionsWrapper) {
        return;
    }
    const toggleOptions = () => {
        if (typeSelect.value === 'select') {
            optionsWrapper.style.display = '';
        } else {
            optionsWrapper.style.display = 'none';
        }
    };
    typeSelect.addEventListener('change', toggleOptions);
    toggleOptions();
})();
</script>
