<?php
$typeOptions = $typeOptions ?? [];
$filters = array_merge(['type' => '', 'start' => '', 'end' => ''], $filters ?? []);
$report = $report ?? null;
$errors = $errors ?? [];
$adminSection = $adminSection ?? 'logs';

$queryBase = [];
if ($filters['type'] !== '') {
    $queryBase['type'] = $filters['type'];
}
if ($filters['start'] !== '') {
    $queryBase['start'] = $filters['start'];
}
if ($filters['end'] !== '') {
    $queryBase['end'] = $filters['end'];
}

$buildPageUrl = static function (array $base, int $page): string {
    $query = $base;
    if ($page > 1) {
        $query['page'] = $page;
    } else {
        unset($query['page']);
    }
    $suffix = $query !== [] ? '?' . http_build_query($query) : '';

    return app_url('admin/logs' . $suffix);
};
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--secondary">Logs &amp; Auditoria</p>
            <h1 class="page__title">Relatório de Logs</h1>
            <p class="page__subtitle">Selecione o tipo de log e o intervalo para visualizar apenas as informações relevantes.</p>
        </div>
        <div class="page__actions">
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/categories'), ENT_QUOTES, 'UTF-8'); ?>">&larr; Voltar para Admin</a>
        </div>
    </div>
    <?php include APP_PATH . '/Views/admin/nav.php'; ?>

    <?php if (!empty($errors)): ?>
        <div class="alert alert--error">
            <?php foreach ($errors as $error): ?>
                <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="card card--elevated" style="margin-bottom:1.5rem;">
        <div class="card__title">Filtros</div>
        <form method="get" action="<?= htmlspecialchars(app_url('admin/logs'), ENT_QUOTES, 'UTF-8'); ?>" class="form-grid" style="align-items:flex-end;">
            <div>
                <label class="input-label" for="filter-type">Tipo de log</label>
                <select class="select-control" id="filter-type" name="type" required>
                    <option value="">Selecione</option>
                    <?php foreach ($typeOptions as $value => $label): ?>
                        <option value="<?= htmlspecialchars($value, ENT_QUOTES, 'UTF-8'); ?>"<?= $filters['type'] === $value ? ' selected' : ''; ?>>
                            <?= htmlspecialchars($label, ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div>
                <label class="input-label" for="filter-start">Data inicial</label>
                <input class="input-control" id="filter-start" type="date" name="start" value="<?= htmlspecialchars($filters['start'], ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div>
                <label class="input-label" for="filter-end">Data final</label>
                <input class="input-control" id="filter-end" type="date" name="end" value="<?= htmlspecialchars($filters['end'], ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div style="display:flex;gap:0.5rem;align-items:center;">
                <button class="btn" type="submit" name="filter" value="1">Filtrar</button>
                <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/logs'), ENT_QUOTES, 'UTF-8'); ?>">Limpar</a>
            </div>
        </form>
    </div>

    <?php if ($report === null): ?>
        <div class="card card--placeholder">
            <div class="card__title">Nenhum relatório selecionado</div>
            <p class="muted">Selecione o tipo de log e o período desejado para carregar o relatório correspondente.</p>
        </div>
    <?php else: ?>
        <div class="card card--elevated">
            <div class="card__title"><?= htmlspecialchars($report['title'] ?? 'Relatório', ENT_QUOTES, 'UTF-8'); ?></div>
            <div class="table-wrapper">
                <?php switch ($report['type'] ?? ''):
                    case 'audit': ?>
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>Data/Hora</th>
                                    <th>Usuário</th>
                                    <th>Entidade</th>
                                    <th>Ação</th>
                                    <th>Detalhes</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($report['items'] as $row): ?>
                                    <tr>
                                        <td><?= htmlspecialchars(date('d/m/Y H:i', strtotime((string) ($row['created_at'] ?? 'now'))), ENT_QUOTES, 'UTF-8'); ?></td>
                                        <td><?= htmlspecialchars($row['user_name'] ?? 'Sistema', ENT_QUOTES, 'UTF-8'); ?></td>
                                        <td><?= htmlspecialchars(($row['entity'] ?? '-') . (isset($row['entity_id']) ? ' #' . (int) $row['entity_id'] : ''), ENT_QUOTES, 'UTF-8'); ?></td>
                                        <td><?= htmlspecialchars($row['action'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                                        <td style="max-width:420px;">
                                            <?php if (!empty($row['payload'])): ?>
                                                <code style="white-space:pre-wrap;display:block;font-size:0.8rem;"><?= htmlspecialchars(json_encode($row['payload'], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES), ENT_QUOTES, 'UTF-8'); ?></code>
                                            <?php else: ?>
                                                <span class="muted">-</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                <?php if (empty($report['items'])): ?>
                                    <tr><td colspan="5" style="text-align:center;padding:1rem;">Nenhum registro encontrado para o período.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <?php break; ?>
                    <?php default: ?>
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>Data/Hora</th>
                                    <th>Nível</th>
                                    <th>Mensagem</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($report['items'] as $row): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($row['timestamp'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                                        <td>
                                            <?php if (!empty($row['level'])): ?>
                                                <span class="badge badge--secondary"><?= htmlspecialchars($row['level'], ENT_QUOTES, 'UTF-8'); ?></span>
                                            <?php else: ?>
                                                <span class="badge badge--neutral">log</span>
                                            <?php endif; ?>
                                        </td>
                                        <td style="max-width:600px;">
                                            <code style="white-space:pre-wrap;display:block;font-size:0.85rem;"><?= htmlspecialchars($row['message'] ?? '', ENT_QUOTES, 'UTF-8'); ?></code>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                <?php if (empty($report['items'])): ?>
                                    <tr><td colspan="3" style="text-align:center;padding:1rem;">Nenhum registro encontrado para o período.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                <?php endswitch; ?>
            </div>

            <?php
            $pagination = $report['pagination'] ?? ['page' => 1, 'pages' => 1, 'total' => 0];
            if (($pagination['pages'] ?? 1) > 1):
                $currentPage = (int) ($pagination['page'] ?? 1);
                ?>
                <nav class="pagination">
                    <?php if ($currentPage > 1): ?>
                        <a class="pagination__link" href="<?= htmlspecialchars($buildPageUrl($queryBase, $currentPage - 1), ENT_QUOTES, 'UTF-8'); ?>">&laquo; Anterior</a>
                    <?php endif; ?>
                    <span class="pagination__current">Página <?= (int) $currentPage; ?> de <?= (int) ($pagination['pages'] ?? 1); ?></span>
                    <?php if ($currentPage < ($pagination['pages'] ?? 1)): ?>
                        <a class="pagination__link" href="<?= htmlspecialchars($buildPageUrl($queryBase, $currentPage + 1), ENT_QUOTES, 'UTF-8'); ?>">Próxima &raquo;</a>
                    <?php endif; ?>
                </nav>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</section>
