<?php
$flashMessage = $flash['success'] ?? null;
$errors = $errors ?? [];
$adminSection = $adminSection ?? 'queues';
$queueRecord = $queueRecord ?? null;
$queueId = (int) ($queueRecord['id'] ?? 0);
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Administração</p>
            <h1 class="page__title">Excluir fila</h1>
            <p class="page__subtitle">Essa ação remove a fila selecionada do catálogo.</p>
        </div>
        <div>
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/queues'), ENT_QUOTES, 'UTF-8'); ?>">Voltar para a lista</a>
        </div>
    </div>
    <?php include APP_PATH . '/Views/admin/nav.php'; ?>

    <?php if ($flashMessage): ?>
        <div class="alert alert--info"><?= htmlspecialchars($flashMessage, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>
    <?php if (!empty($errors)): ?>
        <div class="alert alert--error">
            <?php foreach ($errors as $error): ?>
                <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <div class="card__title">Confirmação</div>
        <p>Você está prestes a remover a fila <strong><?= htmlspecialchars($queueRecord['name'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></strong> (<code><?= htmlspecialchars($queueRecord['slug'] ?? '', ENT_QUOTES, 'UTF-8'); ?></code>).</p>
        <p class="muted">Se houver tickets vinculados, a exclusão será bloqueada.</p>
        <form method="post" action="<?= htmlspecialchars(app_url('admin/queues/delete?id=' . $queueId), ENT_QUOTES, 'UTF-8'); ?>" style="display:flex;gap:0.5rem;flex-wrap:wrap;">
            <?= csrf_input(); ?>
            <button class="btn btn--outline" type="submit">Confirmar exclusão</button>
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/queues'), ENT_QUOTES, 'UTF-8'); ?>">Cancelar</a>
        </form>
    </div>
</section>
