<?php
$pageTitle = 'Login';
$bodyClass = 'layout layout--auth';
$themeVars = theme_variables();
$brandName = theme_brand();
$brandLogo = theme_logo_url();
$benefits = [
    'Acompanhe status em tempo real',
    'Histórico e rastreabilidade',
    'Respostas rápidas e organização por fila/SLA',
];
?>
<style>
    .login-page {
        /*min-height: 100vh;*/
        display: flex;
        align-items: stretch;
        background: linear-gradient(135deg, rgba(<?= hexdec(substr($themeVars['--color-primary'], 1, 2)); ?>, <?= hexdec(substr($themeVars['--color-primary'], 3, 2)); ?>, <?= hexdec(substr($themeVars['--color-primary'], 5, 2)); ?>, 0.08), rgba(0, 0, 0, 0.04));
        padding: 2rem;
        box-sizing: border-box;
    }
    .login-grid {
        width: 100%;
        max-width: 1200px;
        margin: 0 auto;
        display: grid;
        grid-template-columns: minmax(320px, 1.2fr) minmax(320px, 0.8fr);
        gap: 2rem;
        align-items: center;
    }
    .login-info {
        color: #0b1a2b;
        display: flex;
        flex-direction: column;
        /* justify-content: center; */
        padding: 2rem;
    }
    .login-info__brand {
        display: flex;
        align-items: center;
        gap: 1rem;
        margin-bottom: 2rem;
    }
    .login-info__brand img {
        max-width: 120px;
        max-height: 60px;
        object-fit: contain;
    }
    .login-info__headline {
        font-size: 2rem;
        font-weight: 600;
        margin: 0 0 1rem;
        color: #071120;
    }
    .login-info__subtitle {
        font-size: 1.1rem;
        color: #3a4a62;
        margin-bottom: 1.5rem;
    }
    .login-info__list {
        list-style: none;
        padding: 0;
        margin: 0 0 2rem;
    }
    .login-info__list li {
        display: flex;
        align-items: center;
        gap: 0.75rem;
        margin-bottom: 0.5rem;
        font-weight: 500;
        color: #1c2b3d;
    }
    .login-info__list li::before {
        content: '';
        width: 10px;
        height: 10px;
        border-radius: 50%;
        background: <?= htmlspecialchars($themeVars['--color-primary'] ?? '#ff7a18', ENT_QUOTES, 'UTF-8'); ?>;
    }
    .login-card {
        background: #fff;
        border-radius: 1rem;
        padding: 2rem;
        box-shadow: 0 20px 45px rgba(15, 23, 42, 0.12);
        display: flex;
        flex-direction: column;
        gap: 1.5rem;
        align-self: center;
        height: auto;
        max-height: none;
    }
    .login-card h2 {
        margin: 0;
        font-size: 1.6rem;
    }
    .login-form {
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }
    .login-form .input-control {
        height: 48px;
        border-radius: 10px;
        border: 1px solid #d9dce8;
        padding: 0.75rem 1rem;
        font-size: 1rem;
        transition: border 0.2s, box-shadow 0.2s;
    }
    .login-form .input-control:focus {
        border-color: <?= htmlspecialchars($themeVars['--color-primary'] ?? '#ff7a18', ENT_QUOTES, 'UTF-8'); ?>;
        outline: none;
        box-shadow: 0 0 0 3px rgba(255, 122, 24, 0.15);
    }
    .login-form .btn {
        height: 48px;
        border-radius: 10px;
        font-size: 1rem;
    }
    .login-card__footer {
        font-size: 0.9rem;
        color: #6b7280;
        text-align: center;
    }
    @media (max-width: 900px) {
        .login-page {
            padding: 1.5rem 1rem;
        }
        .login-grid {
            grid-template-columns: 1fr;
        }
        .login-info {
            padding: 0;
            text-align: center;
        }
        .login-info__brand {
            justify-content: center;
        }
        .login-card {
            padding: 1.5rem;
            width: 100%;
        }
    }
</style>

<section class="login-page">
    <div class="login-grid">
        <div class="login-info">
            
            <h1 class="login-info__headline">Central de Atendimento</h1>
            <p class="login-info__subtitle">Abra chamados, acompanhe solicitações e organize todo o fluxo de atendimento em um único lugar.</p>
            <ul class="login-info__list">
                <?php foreach ($benefits as $benefit): ?>
                    <li><?= htmlspecialchars($benefit, ENT_QUOTES, 'UTF-8'); ?></li>
                <?php endforeach; ?>
            </ul>
            <small style="color:#94a3b8;">&copy; <?= date('Y'); ?> <?= htmlspecialchars($brandName, ENT_QUOTES, 'UTF-8'); ?>. Todos os direitos reservados.</small>
        </div>

        <div class="login-card">
            <div>
                <p class="badge badge--secondary">Acesso seguro</p>
                <h2>Entrar no portal</h2>
                <p class="page__subtitle" style="margin:0;">Use seu e-mail corporativo ou token SSO fornecido pela intranet.</p>
            </div>

            <?php if (!empty($errors)): ?>
                <div class="alert alert--error">
                    <?php foreach ($errors as $error): ?>
                        <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <form method="post" action="<?= htmlspecialchars(app_url('login'), ENT_QUOTES, 'UTF-8'); ?>" class="login-form">
                <?= csrf_input(); ?>
                <div>
                    <label class="input-label" for="email">E-mail</label>
                    <input class="input-control" type="email" name="email" id="email" value="<?= htmlspecialchars($old['email'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required autofocus>
                </div>
                <div>
                    <label class="input-label" for="password">Senha</label>
                    <input class="input-control" type="password" name="password" id="password" required>
                </div>
                <input type="hidden" name="redirect" value="<?= htmlspecialchars($old['redirect'] ?? '/dashboard', ENT_QUOTES, 'UTF-8'); ?>">
                <button class="btn" type="submit">Entrar</button>
            </form>

            <!--<div class="card card--gradient" style="margin-top:1rem;">
                <h3 class="card__title">SSO Intranet</h3>
                <p style="margin:0 0 1rem;">Utilize o botão “HelpDesk SSO” na intranet para gerar um token automático.</p>
                <a class="btn btn--secondary" href="< ? = // htmlspecialchars(app_url('sso'), ENT_QUOTES, 'UTF-8'); ?>">Receber token</a>
            </div>-->

            <div class="login-card__footer">
                Precisa de ajuda? Entre em contato com o suporte interno.
            </div>
        </div>
    </div>
</section>
