<?php
$pageTitle = $pageTitle ?? 'Dashboard';
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Bem-vindo(a)</p>
            <h1 class="page__title"><?= htmlspecialchars($user['name'] ?? 'Operador', ENT_QUOTES, 'UTF-8'); ?></h1>
            <p class="page__subtitle">Visualize rapidamente indicadores, componentes e o comportamento responsivo do tema.</p>
        </div>
        <div class="page__actions">
            <a class="btn" href="#">Novo Chamado</a>
            <a class="btn btn--outline" href="#demo-modal">Abrir Modal</a>
        </div>
    </div>

    <div class="grid-cards">
        <?php foreach ($heroStats as $stat): ?>
            <div class="card stat-card">
                <span class="badge badge--neutral"><?= htmlspecialchars($stat['badge'], ENT_QUOTES, 'UTF-8'); ?></span>
                <div class="stat-card__value"><?= htmlspecialchars($stat['value'], ENT_QUOTES, 'UTF-8'); ?></div>
                <span><?= htmlspecialchars($stat['label'], ENT_QUOTES, 'UTF-8'); ?></span>
            </div>
        <?php endforeach; ?>
    </div>

    <div class="responsive-stack">
        <div class="card">
            <h2 class="card__title">Componentes básicos</h2>
            <div class="component-group">
                <div class="component-group__block">
                    <label class="input-label" for="component-email">Input</label>
                    <input class="input-control" id="component-email" type="email" placeholder="email@sinarco.com">
                    <label class="input-label" for="component-select">Select</label>
                    <select class="select-control" id="component-select">
                        <option>Filtrar por fila</option>
                        <option>Central TI</option>
                        <option>NOC 24x7</option>
                    </select>
                </div>
                <div class="component-group__block">
                    <label class="input-label" for="component-text">Textarea</label>
                    <textarea class="textarea-control" id="component-text" placeholder="Descreva seu chamado..."></textarea>
                    <div>
                        <span class="badge badge--secondary">Badge</span>
                        <span class="badge badge--primary">Prioridade</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <h2 class="card__title">Botões</h2>
            <div class="page__actions">
                <button class="btn" type="button">Primário</button>
                <button class="btn btn--secondary" type="button">Secundário</button>
                <button class="btn btn--outline" type="button">Outline</button>
            </div>
        </div>
    </div>

    <div class="card">
        <h2 class="card__title">Chamados recentes</h2>
        <div class="grid-cards">
            <?php foreach ($ticketsPreview as $ticket): ?>
                <div class="card card--gradient">
                    <strong><?= htmlspecialchars($ticket['reference'], ENT_QUOTES, 'UTF-8'); ?></strong>
                    <p><?= htmlspecialchars($ticket['subject'], ENT_QUOTES, 'UTF-8'); ?></p>
                    <div class="page__actions">
                        <span class="badge badge--secondary"><?= htmlspecialchars($ticket['status'], ENT_QUOTES, 'UTF-8'); ?></span>
                        <span class="badge badge--primary"><?= htmlspecialchars($ticket['priority'], ENT_QUOTES, 'UTF-8'); ?></span>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <div class="card card--elevated">
        <h2 class="card__title">Modal e Toast</h2>
        <p>Este modal utiliza apenas HTML e CSS (via :target). A pilha de toasts fica no canto inferior direito e aceita estilos `info`, `success`, `error`.</p>
        <div class="page__actions">
            <a class="btn btn--secondary" href="#demo-modal">Ver Modal</a>
            <div class="toast toast--success">
                <div>
                    <strong>Toast de exemplo</strong>
                    <p>Mensagem pronta para feedback rápido.</p>
                </div>
                <span class="badge badge--neutral">ok</span>
            </div>
        </div>
    </div>
</section>

<div class="modal" id="demo-modal">
    <div class="modal__content">
        <h3>Modal responsivo</h3>
        <p>Use este componente para aprovar chamados, transferir filas ou confirmar ações críticas. Todo o estilo respeita as variáveis do tema.</p>
        <a class="btn btn--secondary" href="#">Confirmar ação</a>
        <a class="modal__close" href="#">Fechar modal</a>
    </div>
</div>
