<?php
$checks = $checks ?? [];
$meta = $meta ?? [];
$statusClass = static function (string $status): string {
    return match ($status) {
        'ok' => 'badge--success',
        'warning' => 'badge--warning',
        'error' => 'badge--danger',
        default => 'badge--neutral',
    };
};
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--secondary">Monitoramento</p>
            <h1 class="page__title">Status do HelpDesk</h1>
            <p class="page__subtitle">Resumo rápido das dependências e apontamentos operacionais do ambiente.</p>
        </div>
    </div>

    <div class="card card--gradient" style="margin-bottom:1.5rem;">
        <div style="display:flex;flex-wrap:wrap;gap:1rem;">
            <div>
                <p class="muted">Capturado em</p>
                <strong><?= htmlspecialchars($meta['time'] ?? date('Y-m-d H:i:s'), ENT_QUOTES, 'UTF-8'); ?></strong>
            </div>
            <div>
                <p class="muted">Timezone</p>
                <strong><?= htmlspecialchars($meta['timezone'] ?? '', ENT_QUOTES, 'UTF-8'); ?></strong>
            </div>
            <div>
                <p class="muted">PHP</p>
                <strong><?= htmlspecialchars($meta['php'] ?? PHP_VERSION, ENT_QUOTES, 'UTF-8'); ?></strong>
            </div>
            <div>
                <p class="muted">Modo debug</p>
                <strong><?= !empty($meta['debug']) ? 'Ativo' : 'Desligado'; ?></strong>
            </div>
            <div>
                <p class="muted">Cron notificações</p>
                <code><?= htmlspecialchars($meta['cron_command'] ?? '', ENT_QUOTES, 'UTF-8'); ?></code>
            </div>
        </div>
    </div>

    <div class="responsive-stack">
        <?php foreach ($checks as $check): ?>
            <div class="card">
                <div style="display:flex;justify-content:space-between;align-items:center;">
                    <h2 style="margin:0;font-size:1.1rem;"><?= htmlspecialchars($check['label'] ?? 'Check', ENT_QUOTES, 'UTF-8'); ?></h2>
                    <span class="badge <?= $statusClass($check['status'] ?? ''); ?>">
                        <?= htmlspecialchars(strtoupper((string) ($check['status'] ?? '')), ENT_QUOTES, 'UTF-8'); ?>
                    </span>
                </div>
                <p style="margin-top:0.75rem;color:rgba(0,0,0,0.7);"><?= htmlspecialchars($check['details'] ?? '', ENT_QUOTES, 'UTF-8'); ?></p>
            </div>
        <?php endforeach; ?>
        <?php if (empty($checks)): ?>
            <div class="card">
                <p>Nenhum check configurado.</p>
            </div>
        <?php endif; ?>
    </div>
</section>
