(function () {
    document.addEventListener('DOMContentLoaded', function () {
        var audio = document.querySelector('[data-emergency-audio]');
        var toggle = document.querySelector('[data-emergency-audio-toggle]');
        var statusEl = document.querySelector('[data-emergency-audio-status]');

        if (!audio || !toggle) {
            console.warn('[EmergencyAudio] Elementos não encontrados.', { hasAudio: !!audio, hasToggle: !!toggle });
            return;
        }

        var activateLabel = 'Silenciar alerta sonoro';
        var idleLabel = 'Ativar alerta sonoro';

        var updateStatus = function (message) {
            if (statusEl) {
                statusEl.textContent = message;
            }
        };

        updateStatus('Alerta sonoro inativo.');

        var playAudio = function () {
            updateStatus('Inicializando alerta sonoro...');
            audio.pause();
            audio.currentTime = 0;
            audio.load();
            audio.volume = 0.75;

            var promise = audio.play();
            if (promise && typeof promise.then === 'function') {
                promise
                    .then(function () {
                        toggle.textContent = activateLabel;
                        toggle.classList.add('is-active');
                        updateStatus('Alerta sonoro reproduzindo...');
                        console.info('[EmergencyAudio] Reprodução iniciada.');
                    })
                    .catch(function (error) {
                        toggle.textContent = idleLabel;
                        toggle.classList.remove('is-active');
                        updateStatus('Falha ao reproduzir (ver console).');
                        console.error('[EmergencyAudio] Erro ao executar áudio.', error);
                    });
            } else {
                toggle.textContent = activateLabel;
                toggle.classList.add('is-active');
                updateStatus('Alerta sonoro reproduzindo...');
                console.info('[EmergencyAudio] Reprodução iniciada (sem promise).');
            }
        };

        var stopAudio = function () {
            audio.pause();
            audio.currentTime = 0;
            toggle.textContent = idleLabel;
            toggle.classList.remove('is-active');
            updateStatus('Alerta sonoro inativo.');
            console.info('[EmergencyAudio] Reprodução parada manualmente.');
        };

        toggle.addEventListener('click', function () {
            console.log('[EmergencyAudio] Botão clicado. Pausado?', audio.paused);
            if (audio.paused) {
                playAudio();
            } else {
                stopAudio();
            }
        });

        toggle.addEventListener('keydown', function (event) {
            if (event.key === 'Enter' || event.key === ' ') {
                event.preventDefault();
                toggle.click();
            }
        });
    });
})();
