<?php
declare(strict_types=1);

use App\Repositories\NotificationOutboxRepository;
use App\Services\NotificationService;

define('BASE_PATH', dirname(__DIR__));
define('APP_PATH', BASE_PATH . '/app');

spl_autoload_register(static function (string $class): void {
    $prefix = 'App\\';
    if (!str_starts_with($class, $prefix)) {
        return;
    }

    $relative = str_replace('\\', '/', substr($class, strlen($prefix)));
    $file = APP_PATH . '/' . $relative . '.php';

    if (file_exists($file)) {
        require_once $file;
    }
});

require_once APP_PATH . '/Config/database.php';

$repository = new NotificationOutboxRepository();
$service = new NotificationService($repository);
$service->processPending();

echo '[' . date('Y-m-d H:i:s') . "] Notificações processadas.\n";
