<?php
declare(strict_types=1);

use App\Repositories\AdminAuditRepository;

function app_log(string $level, string $message, array $context = []): void
{
    $logDir = BASE_PATH . '/storage/logs';
    if (!is_dir($logDir)) {
        mkdir($logDir, 0775, true);
    }

    $contextLine = $context === [] ? '' : json_encode($context, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    $line = sprintf("[%s] %s: %s %s%s", date('Y-m-d H:i:s'), strtoupper($level), $message, $contextLine ?? '', PHP_EOL);
    file_put_contents($logDir . '/app.log', $line, FILE_APPEND);
}

function audit_log(string $entity, string $action, ?int $entityId = null, array $payload = []): void
{
    $repo = $GLOBALS['audit.repo'] ?? null;
    if ($repo instanceof AdminAuditRepository) {
        $userId = $_SESSION['auth_user']['id'] ?? null;
        $repo->log($userId, $entity, $action, $entityId, $payload);
    }

    app_log('INFO', sprintf('AUDIT %s.%s', $entity, $action), [
        'entity_id' => $entityId,
        'payload' => $payload,
    ]);
}
