<?php
declare(strict_types=1);

function base_dir(): string
{
    return $GLOBALS['app.base_dir'] ?? '';
}

function base_entry(): string
{
    return $GLOBALS['app.entry_point'] ?? '';
}

function base_uri(): string
{
    return base_dir();
}

function app_url(string $path = ''): string
{
    if (preg_match('#^https?://#i', $path)) {
        return $path;
    }

    $path = trim($path);
    [$cleanPath, $query] = partition_query($path);

    if ($cleanPath === '' || $cleanPath === '/') {
        $url = base_dir() === '' ? '/' : base_dir() . '/';
        return rebuild_url($url, $query);
    }

    $entry = base_entry() ?: (base_dir() === '' ? '/index.php' : base_dir() . '/index.php');
    $entry = rtrim($entry, '/');
    $url = $entry . normalize_path($cleanPath);

    return rebuild_url($url, $query);
}

function asset_url(string $path): string
{
    if (preg_match('#^https?://#i', $path)) {
        return $path;
    }

    $normalized = normalize_path($path);
    $base = base_dir();

    if ($base === '' || $base === '/') {
        return $normalized;
    }

    return rtrim($base, '/') . $normalized;
}

function normalize_path(string $path): string
{
    if ($path === '') {
        return '/';
    }

    if ($path[0] !== '/') {
        $path = '/' . $path;
    }

    return $path === '//' ? '/' : $path;
}

/**
 * @return array{0:string,1:?string}
 */
function partition_query(string $path): array
{
    $parts = explode('?', $path, 2);
    $cleanPath = $parts[0];
    $query = $parts[1] ?? null;

    return [$cleanPath, $query];
}

function rebuild_url(string $path, ?string $query): string
{
    if ($path === '') {
        $path = '/';
    }

    if ($path !== '/' && str_ends_with($path, '//')) {
        $path = rtrim($path, '/');
    }

    return $query !== null && $query !== '' ? $path . '?' . $query : $path;
}
