<?php
declare(strict_types=1);

namespace App\Middlewares;

use App\Services\AuthService;

final class AuthMiddleware
{
    public function __construct(
        private readonly AuthService $authService
    ) {
    }

    public function handle(): void
    {
        if ($this->authService->check()) {
            return;
        }

        $current = $this->sanitizeRedirectTarget($_SERVER['REQUEST_URI'] ?? '/dashboard');
        header('Location: ' . app_url('login') . '?redirect=' . urlencode($current));
        exit;
    }

    private function sanitizeRedirectTarget(string $target): string
    {
        if ($target === '' || !str_starts_with($target, '/')) {
            return '/dashboard';
        }

        return $target;
    }
}
