<?php
declare(strict_types=1);

namespace App\Repositories;

use App\Config\Database;
use PDO;

final class EmergencyActionRepository
{
    /**
     * @param array<string, mixed> $data
     */
    public function create(array $data): int
    {
        $columns = array_keys($data);
        $placeholders = array_map(static fn (string $column): string => ':' . $column, $columns);
        $sql = sprintf(
            'INSERT INTO ticket_emergency_actions (%s) VALUES (%s)',
            implode(', ', $columns),
            implode(', ', $placeholders)
        );

        Database::run($sql, $data);

        return (int) Database::connection()->lastInsertId();
    }

    /**
     * @return array<int, array<string, mixed>>
     */
    public function listByTicket(int $ticketId): array
    {
        $sql = <<<SQL
            SELECT
                a.id,
                a.ticket_id,
                a.action_type,
                a.authority,
                a.contact_name,
                a.contact_phone,
                a.protocol_code,
                a.occurred_at,
                a.notes,
                a.created_at,
                creator.name AS created_by_name
            FROM ticket_emergency_actions a
            LEFT JOIN users creator ON creator.id = a.created_by
            WHERE a.ticket_id = :ticket_id
            ORDER BY a.occurred_at DESC, a.id DESC
        SQL;

        $statement = Database::run($sql, ['ticket_id' => $ticketId]);
        return $statement->fetchAll(PDO::FETCH_ASSOC) ?: [];
    }
}
