<?php
$flashMessage = $flash['success'] ?? null;
$errors = $errors ?? [];
$adminSection = $adminSection ?? 'categories';
$old = $old ?? [];
$categoryRecord = $categoryRecord ?? null;
$formTitle = $formTitle ?? 'Nova categoria';
$formAction = $formAction ?? app_url('admin/categories/store');
$isEdit = $isEdit ?? false;
$parentOptions = $parentOptions ?? [];
$queues = $queues ?? [];

$formData = $categoryRecord !== null ? $categoryRecord : [];
if (!empty($old)) {
    $formData = array_merge($formData, $old);
}

$isActive = array_key_exists('is_active', $formData)
    ? (int) $formData['is_active'] === 1
    : true;
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Administração</p>
            <h1 class="page__title"><?= htmlspecialchars($formTitle, ENT_QUOTES, 'UTF-8'); ?></h1>
            <p class="page__subtitle"><?= $isEdit ? 'Atualize a categoria selecionada e seus vínculos.' : 'Cadastre uma nova categoria ou subcategoria.'; ?></p>
        </div>
        <div>
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/categories'), ENT_QUOTES, 'UTF-8'); ?>">Voltar para a lista</a>
        </div>
    </div>
    <?php include APP_PATH . '/Views/admin/nav.php'; ?>

    <?php if ($flashMessage): ?>
        <div class="alert alert--info"><?= htmlspecialchars($flashMessage, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>
    <?php if (!empty($errors)): ?>
        <div class="alert alert--error">
            <?php foreach ($errors as $error): ?>
                <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <div class="card__title"><?= htmlspecialchars($formTitle, ENT_QUOTES, 'UTF-8'); ?></div>
        <form method="post" action="<?= htmlspecialchars($formAction, ENT_QUOTES, 'UTF-8'); ?>" class="form-grid">
            <?= csrf_input(); ?>
            <div>
                <label class="input-label" for="category-name">Nome da categoria</label>
                <input class="input-control" id="category-name" name="name" required minlength="3" value="<?= htmlspecialchars($formData['name'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div>
                <label class="input-label" for="category-slug">Slug/código</label>
                <input class="input-control" id="category-slug" name="slug" required minlength="3" value="<?= htmlspecialchars($formData['slug'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" placeholder="Ex: suporte-ti-software">
                <small class="muted">Somente letras, números, hífen ou underline.</small>
            </div>
            <?php
            $selectedParentId = null;
            if (array_key_exists('parent_id', $formData)) {
                $parentValue = $formData['parent_id'];
                if (is_string($parentValue)) {
                    $parentValue = trim($parentValue);
                }
                if ($parentValue !== '' && (int) $parentValue !== 0) {
                    $selectedParentId = (int) $parentValue;
                }
            }
            ?>
            <div>
                <label class="input-label" for="category-parent">Categoria pai</label>
                <select class="select-control" id="category-parent" name="parent_id">
                    <option value=""<?= $selectedParentId === null ? ' selected' : ''; ?>>Selecione...</option>
                    <?php foreach ($parentOptions as $parent): ?>
                        <option value="<?= (int) $parent['id']; ?>"<?= $selectedParentId !== null && $selectedParentId === (int) $parent['id'] ? ' selected' : ''; ?>>
                            <?= htmlspecialchars($parent['name'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div>
                <label class="input-label" for="category-queue">Fila padrão</label>
                <select class="select-control" id="category-queue" name="queue_id">
                    <option value="">Automático</option>
                    <?php foreach ($queues as $queue): ?>
                        <option value="<?= (int) $queue['id']; ?>"<?= (int) ($formData['queue_id'] ?? 0) === (int) $queue['id'] ? ' selected' : ''; ?>>
                            <?= htmlspecialchars($queue['name'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div style="grid-column:1 / -1;">
                <label class="input-label" for="category-description">Descrição (opcional)</label>
                <textarea class="textarea-control" id="category-description" name="description" rows="2"><?= htmlspecialchars($formData['description'] ?? '', ENT_QUOTES, 'UTF-8'); ?></textarea>
            </div>
            <div>
                <label class="input-label" for="category-sort">Ordem de exibição</label>
                <input class="input-control" id="category-sort" type="number" min="0" name="sort_order" value="<?= htmlspecialchars((string) ($formData['sort_order'] ?? 0), ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <label class="checkbox-control" style="margin-top:0.5rem;">
                <input type="checkbox" name="is_active" value="1"<?= $isActive ? ' checked' : ''; ?>>
                <span>Categoria ativa</span>
            </label>
            <div style="align-self:flex-end;">
                <button class="btn" type="submit"><?= $isEdit ? 'Salvar alterações' : 'Criar categoria'; ?></button>
            </div>
        </form>
    </div>
</section>
