<?php
$typeRecord = $typeRecord ?? null;
$name = $typeRecord['name'] ?? 'Tipo';
$slug = $typeRecord['slug'] ?? '';
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Administração</p>
            <h1 class="page__title">Remover tipo de cliente</h1>
            <p class="page__subtitle">Confirme a exclusão somente se não houver vínculos com tickets ou SLAs.</p>
        </div>
        <div>
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/customer-types'), ENT_QUOTES, 'UTF-8'); ?>">Voltar</a>
        </div>
    </div>
    <?php include APP_PATH . '/Views/admin/nav.php'; ?>

    <?php if (!empty($errors)): ?>
        <div class="alert alert--error">
            <?php foreach ($errors as $error): ?>
                <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <p>Você está prestes a remover <strong><?= htmlspecialchars($name, ENT_QUOTES, 'UTF-8'); ?></strong> (slug <code><?= htmlspecialchars($slug, ENT_QUOTES, 'UTF-8'); ?></code>).</p>
        <p>Caso existam tickets ou políticas usando este tipo, a exclusão será bloqueada. Considere apenas inativá-lo.</p>
        <form method="post" action="<?= htmlspecialchars(app_url('admin/customer-types/delete?id=' . (int) ($typeRecord['id'] ?? 0)), ENT_QUOTES, 'UTF-8'); ?>" style="display:flex;gap:0.5rem;flex-wrap:wrap;">
            <?= csrf_input(); ?>
            <input type="hidden" name="redirect" value="admin/customer-types">
            <button class="btn btn--danger" type="submit">Confirmar exclusão</button>
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/customer-types'), ENT_QUOTES, 'UTF-8'); ?>">Cancelar</a>
        </form>
    </div>
</section>
