<?php
$flashMessage = $flash['success'] ?? null;
$errors = $errors ?? [];
$adminSection = $adminSection ?? 'customer-types';
$old = $old ?? [];
$typeRecord = $typeRecord ?? null;
$formTitle = $formTitle ?? ($isEdit ? 'Editar tipo de cliente' : 'Novo tipo de cliente');
$formAction = $formAction ?? app_url('admin/customer-types/store');
$isEdit = $isEdit ?? false;

$formData = $typeRecord !== null ? $typeRecord : [];
if (!empty($old)) {
    $formData = array_merge($formData, $old);
}
$isActive = array_key_exists('is_active', $formData)
    ? (int) $formData['is_active'] === 1
    : true;
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Administração</p>
            <h1 class="page__title"><?= htmlspecialchars($formTitle, ENT_QUOTES, 'UTF-8'); ?></h1>
            <p class="page__subtitle"><?= $isEdit ? 'Atualize o identificador e a descrição do tipo selecionado.' : 'Defina novos tipos que poderão ser usados ao abrir chamados.'; ?></p>
        </div>
        <div>
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/customer-types'), ENT_QUOTES, 'UTF-8'); ?>">Voltar para a lista</a>
        </div>
    </div>
    <?php include APP_PATH . '/Views/admin/nav.php'; ?>

    <?php if ($flashMessage): ?>
        <div class="alert alert--info"><?= htmlspecialchars($flashMessage, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>
    <?php if (!empty($errors)): ?>
        <div class="alert alert--error">
            <?php foreach ($errors as $error): ?>
                <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <div class="card__title"><?= htmlspecialchars($formTitle, ENT_QUOTES, 'UTF-8'); ?></div>
        <form method="post" action="<?= htmlspecialchars($formAction, ENT_QUOTES, 'UTF-8'); ?>" class="form-grid">
            <?= csrf_input(); ?>
            <div>
                <label class="input-label" for="customer-type-name">Nome</label>
                <input class="input-control" id="customer-type-name" name="name" required minlength="3" value="<?= htmlspecialchars($formData['name'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div>
                <label class="input-label" for="customer-type-slug">Slug</label>
                <input class="input-control" id="customer-type-slug" name="slug" required pattern="[a-z0-9\\-_]{2,60}" value="<?= htmlspecialchars($formData['slug'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" placeholder="Ex: interno, parceiro-premium">
                <small class="muted">Usado internamente em tickets e políticas.</small>
            </div>
            <div style="grid-column:1 / -1;">
                <label class="input-label" for="customer-type-description">Descrição</label>
                <textarea class="input-control" id="customer-type-description" name="description" rows="2"><?= htmlspecialchars($formData['description'] ?? '', ENT_QUOTES, 'UTF-8'); ?></textarea>
            </div>
            <div>
                <label class="input-label" for="customer-type-order">Ordem</label>
                <input class="input-control" id="customer-type-order" type="number" name="sort_order" value="<?= htmlspecialchars((string) ($formData['sort_order'] ?? 0), ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <label class="checkbox-control" style="margin-top:0.5rem;">
                <input type="checkbox" name="is_active" value="1"<?= $isActive ? ' checked' : ''; ?>>
                <span>Disponível para seleção</span>
            </label>
            <div style="align-self:flex-end;">
                <button class="btn" type="submit"><?= $isEdit ? 'Salvar alterações' : 'Criar tipo'; ?></button>
            </div>
        </form>
    </div>
</section>
