<?php
/**
 * @var array<int, array<string, mixed>> $types
 */
$types = $types ?? [];
$pagination = $pagination ?? ['page' => 1, 'pages' => 1, 'total' => 0];
$filters = $filters ?? ['q' => '', 'status' => 'all'];
$flashMessage = $flash['success'] ?? null;
$flashError = $flash['error'] ?? null;
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Administração</p>
            <h1 class="page__title">Tipos de cliente</h1>
            <p class="page__subtitle">Gerencie quais perfis podem ser selecionados ao abrir ou configurar chamados.</p>
        </div>
        <div>
            <a class="btn" href="<?= htmlspecialchars(app_url('admin/customer-types/create'), ENT_QUOTES, 'UTF-8'); ?>">Novo tipo</a>
        </div>
    </div>
    <?php include APP_PATH . '/Views/admin/nav.php'; ?>

    <?php if ($flashMessage): ?>
        <div class="alert alert--info"><?= htmlspecialchars($flashMessage, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>
    <?php if (!empty($errors)): ?>
        <div class="alert alert--error">
            <?php foreach ($errors as $error): ?>
                <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <form method="get" action="<?= htmlspecialchars(app_url('admin/customer-types'), ENT_QUOTES, 'UTF-8'); ?>" class="form-grid" style="align-items:flex-end;">
            <div>
                <label class="input-label" for="filter-q">Buscar</label>
                <input class="input-control" id="filter-q" name="q" placeholder="Nome ou slug" value="<?= htmlspecialchars((string) $filters['q'], ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div>
                <label class="input-label" for="filter-status">Status</label>
                <select class="select-control" id="filter-status" name="status">
                    <option value="all" <?= $filters['status'] === 'all' ? 'selected' : ''; ?>>Todos</option>
                    <option value="active" <?= $filters['status'] === 'active' ? 'selected' : ''; ?>>Ativos</option>
                    <option value="inactive" <?= $filters['status'] === 'inactive' ? 'selected' : ''; ?>>Inativos</option>
                </select>
            </div>
            <div style="align-self:flex-end;">
                <button class="btn" type="submit">Filtrar</button>
            </div>
        </form>
    </div>

    <div class="card card--elevated">
        <div style="overflow-x:auto;">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Slug</th>
                        <th>Descrição</th>
                        <th>Ordem</th>
                        <th>Status</th>
                        <th style="width:220px;"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($types as $type): ?>
                        <tr>
                            <td><?= htmlspecialchars($type['name'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><code><?= htmlspecialchars($type['slug'], ENT_QUOTES, 'UTF-8'); ?></code></td>
                            <td><?= htmlspecialchars($type['description'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?= (int) ($type['sort_order'] ?? 0); ?></td>
                            <td>
                                <span class="badge <?= ((int) $type['is_active'] === 1) ? 'badge--success' : 'badge--secondary'; ?>">
                                    <?= (int) $type['is_active'] === 1 ? 'Ativo' : 'Inativo'; ?>
                                </span>
                            </td>
                            <td style="text-align:right;">
                                <div style="display:flex; gap:0.25rem; justify-content:flex-end;">
                                    <a class="btn btn--sm btn--outline" href="<?= htmlspecialchars(app_url('admin/customer-types/edit?id=' . (int) $type['id']), ENT_QUOTES, 'UTF-8'); ?>">Editar</a>
                                    <form method="post" action="<?= htmlspecialchars(app_url('admin/customer-types/toggle?id=' . (int) $type['id']), ENT_QUOTES, 'UTF-8'); ?>" style="display:inline-block;">
                                        <?= csrf_input(); ?>
                                        <input type="hidden" name="status" value="<?= (int) $type['is_active'] === 1 ? 0 : 1; ?>">
                                        <input type="hidden" name="redirect" value="admin/customer-types<?= isset($_SERVER['QUERY_STRING']) && $_SERVER['QUERY_STRING'] !== '' ? '?' . htmlspecialchars($_SERVER['QUERY_STRING'], ENT_QUOTES, 'UTF-8') : ''; ?>">
                                        <button class="btn btn--sm" type="submit"><?= (int) $type['is_active'] === 1 ? 'Inativar' : 'Ativar'; ?></button>
                                    </form>
                                    <a class="btn btn--sm btn--ghost" href="<?= htmlspecialchars(app_url('admin/customer-types/delete?id=' . (int) $type['id']), ENT_QUOTES, 'UTF-8'); ?>">Excluir</a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if ($types === []): ?>
                        <tr><td colspan="6" style="text-align:center;padding:1.5rem;">Nenhum tipo configurado.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="pagination">
            <span>Página <?= (int) $pagination['page']; ?> de <?= (int) $pagination['pages']; ?> (<?= (int) $pagination['total']; ?> registros)</span>
        </div>
    </div>
</section>
