<?php
$flashMessage = $flash['success'] ?? null;
$errors = $errors ?? [];
$categories = $categories ?? [];
$queues = $queues ?? [];
$fields = $fields ?? [];
$slaPolicies = $slaPolicies ?? [];
$customerTypes = $customerTypes ?? [];
$theme = $theme ?? [];
$roles = $roles ?? [];
$priorities = $priorities ?? [];
$users = $users ?? [];
$auditLogs = $auditLogs ?? [];
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Administração</p>
            <h1 class="page__title">Painel do Gestor</h1>
            <p class="page__subtitle">Configure catálogo, SLAs, filas, tema e usuários para manter o HelpDesk sob controle.</p>
        </div>
        <div class="page__actions">
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/logs'), ENT_QUOTES, 'UTF-8'); ?>">Ver relatório de logs</a>
        </div>
    </div>

    <?php if ($flashMessage): ?>
        <div class="alert alert--info" style="background: rgba(33,150,243,0.15); border:1px solid rgba(33,150,243,0.35); color:#0d47a1;">
            <?= htmlspecialchars($flashMessage, ENT_QUOTES, 'UTF-8'); ?>
        </div>
    <?php endif; ?>
    <?php if (!empty($errors)): ?>
        <div class="alert alert--error">
            <?php foreach ($errors as $error): ?>
                <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="responsive-stack">
        <div class="card">
            <div class="card__title">Categorias / Subcategorias</div>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Slug</th>
                        <th>Categoria pai</th>
                        <th>Fila</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($categories as $category): ?>
                        <tr>
                            <td><?= htmlspecialchars($category['name'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?= htmlspecialchars($category['slug'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?= htmlspecialchars($category['parent_name'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                            <td>
                                <?php
                                    $queue = '';
                                    if (!empty($category['queue_id'])) {
                                        foreach ($queues as $queueRow) {
                                            if ((int) $queueRow['id'] === (int) $category['queue_id']) {
                                                $queue = $queueRow['name'];
                                                break;
                                            }
                                        }
                                    }
                                ?>
                                <?= htmlspecialchars($queue ?: '-', ENT_QUOTES, 'UTF-8'); ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (empty($categories)): ?>
                        <tr><td colspan="4" style="text-align:center;padding:1rem;">Nenhuma categoria cadastrada.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <form method="post" action="<?= htmlspecialchars(app_url('admin'), ENT_QUOTES, 'UTF-8'); ?>" class="form-grid" style="margin-top:1rem;">
                <input type="hidden" name="action" value="create_category">
                <?= csrf_input(); ?>
                <div>
                    <label class="input-label" for="category-name">Nome</label>
                    <input class="input-control" id="category-name" name="name" required>
                </div>
                <div>
                    <label class="input-label" for="category-slug">Slug</label>
                    <input class="input-control" id="category-slug" name="slug" placeholder="opcional">
                </div>
                <div>
                    <label class="input-label" for="category-parent">Categoria pai</label>
                    <select class="select-control" id="category-parent" name="parent_id">
                        <option value="">Raiz</option>
                        <?php foreach ($categories as $category): ?>
                            <option value="<?= (int) $category['id']; ?>"><?= htmlspecialchars($category['name'], ENT_QUOTES, 'UTF-8'); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label class="input-label" for="category-queue">Fila</label>
                    <select class="select-control" id="category-queue" name="queue_id">
                        <option value="">Automático</option>
                        <?php foreach ($queues as $queue): ?>
                            <option value="<?= (int) $queue['id']; ?>"><?= htmlspecialchars($queue['name'], ENT_QUOTES, 'UTF-8'); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label class="input-label" for="category-description">Descrição</label>
                    <input class="input-control" id="category-description" name="description" placeholder="opcional">
                </div>
                <div style="align-self:flex-end;">
                    <button class="btn" type="submit">Adicionar categoria</button>
                </div>
            </form>
        </div>

        <div class="card">
            <div class="card__title">Filas</div>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Fila</th>
                        <th>Slug</th>
                        <th>SLA Resp.</th>
                        <th>SLA Resol.</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($queues as $queue): ?>
                        <tr>
                            <td><?= htmlspecialchars($queue['name'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?= htmlspecialchars($queue['slug'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?= (int) $queue['sla_response_minutes']; ?> min</td>
                            <td><?= (int) $queue['sla_resolution_minutes']; ?> min</td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (empty($queues)): ?>
                        <tr><td colspan="4" style="text-align:center;padding:1rem;">Nenhuma fila cadastrada.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <form method="post" action="<?= htmlspecialchars(app_url('admin'), ENT_QUOTES, 'UTF-8'); ?>" class="form-grid" style="margin-top:1rem;">
                <input type="hidden" name="action" value="create_queue">
                <?= csrf_input(); ?>
                <div>
                    <label class="input-label" for="queue-name">Nome</label>
                    <input class="input-control" id="queue-name" name="name" required>
                </div>
                <div>
                    <label class="input-label" for="queue-slug">Slug</label>
                    <input class="input-control" id="queue-slug" name="slug" placeholder="opcional">
                </div>
                <div>
                    <label class="input-label" for="queue-desc">Descrição</label>
                    <input class="input-control" id="queue-desc" name="description" placeholder="opcional">
                </div>
                <div>
                    <label class="input-label" for="queue-response">SLA resposta (min)</label>
                    <input class="input-control" id="queue-response" name="sla_response_minutes" type="number" min="0" value="60">
                </div>
                <div>
                    <label class="input-label" for="queue-resolution">SLA resolução (min)</label>
                    <input class="input-control" id="queue-resolution" name="sla_resolution_minutes" type="number" min="0" value="480">
                </div>
                <label class="checkbox-control" style="margin-top:0.5rem;">
                    <input type="checkbox" name="is_active" value="1" checked>
                    <span>Fila ativa</span>
                </label>
                <div style="align-self:flex-end;">
                    <button class="btn" type="submit">Criar fila</button>
                </div>
            </form>
        </div>
    </div>

    <div class="responsive-stack">
        <div class="card">
            <div class="card__title">Campos dinâmicos</div>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Categoria</th>
                        <th>Campo</th>
                        <th>Tipo</th>
                        <th>Obrigatório</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($fields as $field): ?>
                        <tr>
                            <td><?= htmlspecialchars($field['category_name'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?= htmlspecialchars($field['label'], ENT_QUOTES, 'UTF-8'); ?> (<?= htmlspecialchars($field['name'], ENT_QUOTES, 'UTF-8'); ?>)</td>
                            <td><?= htmlspecialchars($field['type'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?= ((int) $field['is_required']) === 1 ? 'Sim' : 'Não'; ?></td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (empty($fields)): ?>
                        <tr><td colspan="4" style="text-align:center;padding:1rem;">Nenhum campo configurado.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <form method="post" action="<?= htmlspecialchars(app_url('admin'), ENT_QUOTES, 'UTF-8'); ?>" class="form-grid" style="margin-top:1rem;">
                <input type="hidden" name="action" value="create_field">
                <?= csrf_input(); ?>
                <div>
                    <label class="input-label" for="field-category">Categoria</label>
                    <select class="select-control" id="field-category" name="category_id" required>
                        <option value="">Selecione</option>
                        <?php foreach ($categories as $category): ?>
                            <option value="<?= (int) $category['id']; ?>"><?= htmlspecialchars($category['name'], ENT_QUOTES, 'UTF-8'); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label class="input-label" for="field-label">Rótulo</label>
                    <input class="input-control" id="field-label" name="label" required>
                </div>
                <div>
                    <label class="input-label" for="field-name">Nome técnico</label>
                    <input class="input-control" id="field-name" name="name" placeholder="opcional">
                </div>
                <div>
                    <label class="input-label" for="field-type">Tipo</label>
                    <select class="select-control" id="field-type" name="type">
                        <option value="text">Texto</option>
                        <option value="textarea">Textarea</option>
                        <option value="select">Select</option>
                        <option value="number">Número</option>
                        <option value="boolean">Checkbox</option>
                    </select>
                </div>
                <div>
                    <label class="input-label" for="field-options">Opções (um por linha)</label>
                    <textarea class="textarea-control" id="field-options" name="options" placeholder="Necessário para campos select"></textarea>
                </div>
                <div>
                    <label class="input-label" for="field-order">Ordem</label>
                    <input class="input-control" id="field-order" name="sort_order" type="number" value="0">
                </div>
                <label class="checkbox-control">
                    <input type="checkbox" name="is_required" value="1">
                    <span>Obrigatório</span>
                </label>
                <div style="align-self:flex-end;">
                    <button class="btn" type="submit">Adicionar campo</button>
                </div>
            </form>
        </div>

        <div class="card">
            <div class="card__title">Políticas de SLA</div>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Categoria</th>
                        <th>Prioridade</th>
                        <th>Cliente</th>
                        <th>Resp.</th>
                        <th>Resol.</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($slaPolicies as $policy): ?>
                        <tr>
                            <td><?= htmlspecialchars($policy['category_name'] ?? 'Global', ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?= htmlspecialchars($policy['priority_name'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?= htmlspecialchars($policy['client_type'] ?? 'Todos', ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?= (int) $policy['response_minutes']; ?> min</td>
                            <td><?= (int) $policy['resolution_minutes']; ?> min</td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (empty($slaPolicies)): ?>
                        <tr><td colspan="5" style="text-align:center;padding:1rem;">Nenhuma política configurada.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <form method="post" action="<?= htmlspecialchars(app_url('admin'), ENT_QUOTES, 'UTF-8'); ?>" class="form-grid" style="margin-top:1rem;">
                <input type="hidden" name="action" value="create_sla">
                <?= csrf_input(); ?>
                <div>
                    <label class="input-label" for="sla-category">Categoria</label>
                    <select class="select-control" id="sla-category" name="category_id">
                        <option value="">Global</option>
                        <?php foreach ($categories as $category): ?>
                            <option value="<?= (int) $category['id']; ?>"><?= htmlspecialchars($category['name'], ENT_QUOTES, 'UTF-8'); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label class="input-label" for="sla-priority">Prioridade</label>
                    <select class="select-control" id="sla-priority" name="priority_id" required>
                        <?php foreach ($priorities as $priority): ?>
                            <option value="<?= (int) $priority['id']; ?>"><?= htmlspecialchars($priority['name'], ENT_QUOTES, 'UTF-8'); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label class="input-label" for="sla-client">Tipo cliente</label>
                    <select class="select-control" id="sla-client" name="client_type">
                        <option value="">Todos</option>
                        <?php foreach ($customerTypes as $type): ?>
                            <option value="<?= htmlspecialchars((string) $type['slug'], ENT_QUOTES, 'UTF-8'); ?>">
                                <?= htmlspecialchars($type['name'], ENT_QUOTES, 'UTF-8'); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label class="input-label" for="sla-response">Resposta (min)</label>
                    <input class="input-control" id="sla-response" name="response_minutes" type="number" min="0" value="60">
                </div>
                <div>
                    <label class="input-label" for="sla-resolution">Resolução (min)</label>
                    <input class="input-control" id="sla-resolution" name="resolution_minutes" type="number" min="0" value="240">
                </div>
                <div>
                    <label class="input-label" for="sla-order">Ordem</label>
                    <input class="input-control" id="sla-order" name="sort_order" type="number" value="0">
                </div>
                <label class="checkbox-control">
                    <input type="checkbox" name="is_active" value="1" checked>
                    <span>Política ativa</span>
                </label>
                <div style="align-self:flex-end;">
                    <button class="btn" type="submit">Cadastrar SLA</button>
                </div>
            </form>
        </div>
    </div>

    <div class="responsive-stack">
        <div class="card">
            <div class="card__title">Tema e Branding</div>
            <form method="post" action="<?= htmlspecialchars(app_url('admin'), ENT_QUOTES, 'UTF-8'); ?>" class="form-grid">
                <input type="hidden" name="action" value="update_theme">
                <?= csrf_input(); ?>
                <div>
                    <label class="input-label" for="theme-primary">Cor primária</label>
                    <input class="input-control" id="theme-primary" name="primary_color" value="<?= htmlspecialchars($theme['primary_color'] ?? '#ff7a18', ENT_QUOTES, 'UTF-8'); ?>">
                </div>
                <div>
                    <label class="input-label" for="theme-secondary">Cor secundária</label>
                    <input class="input-control" id="theme-secondary" name="secondary_color" value="<?= htmlspecialchars($theme['secondary_color'] ?? '#6c63ff', ENT_QUOTES, 'UTF-8'); ?>">
                </div>
                <div>
                    <label class="input-label" for="theme-dark">Cor dark</label>
                    <input class="input-control" id="theme-dark" name="dark_color" value="<?= htmlspecialchars($theme['dark_color'] ?? '#1f1f1f', ENT_QUOTES, 'UTF-8'); ?>">
                </div>
                <div>
                    <label class="input-label" for="theme-accent">Accent</label>
                    <input class="input-control" id="theme-accent" name="accent_color" value="<?= htmlspecialchars($theme['accent_color'] ?? '#37474f', ENT_QUOTES, 'UTF-8'); ?>">
                </div>
                <div>
                    <label class="input-label" for="theme-logo">Texto logo</label>
                    <input class="input-control" id="theme-logo" name="logo_text" value="<?= htmlspecialchars($theme['logo_text'] ?? 'HelpDesk', ENT_QUOTES, 'UTF-8'); ?>">
                </div>
                <div style="align-self:flex-end;">
                    <button class="btn" type="submit">Salvar tema</button>
                </div>
            </form>
        </div>

        <div class="card">
            <div class="card__title">Usuários e permissões</div>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>E-mail</th>
                        <th>Perfil</th>
                        <th>Fila</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($users as $userRow): ?>
                        <tr>
                            <td><?= htmlspecialchars($userRow['name'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?= htmlspecialchars($userRow['email'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?= htmlspecialchars($userRow['role_name'] ?? ('#' . $userRow['role_id']), ENT_QUOTES, 'UTF-8'); ?></td>
                            <td>
                                <?php
                                    $userQueue = '-';
                                    if (!empty($userRow['queue_id'])) {
                                        foreach ($queues as $queue) {
                                            if ((int) $queue['id'] === (int) $userRow['queue_id']) {
                                                $userQueue = $queue['name'];
                                                break;
                                            }
                                        }
                                    }
                                ?>
                                <?= htmlspecialchars($userQueue, ENT_QUOTES, 'UTF-8'); ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (empty($users)): ?>
                        <tr><td colspan="4" style="text-align:center;padding:1rem;">Nenhum usuário ativo.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <form method="post" action="<?= htmlspecialchars(app_url('admin'), ENT_QUOTES, 'UTF-8'); ?>" class="form-grid" style="margin-top:1rem;">
                <input type="hidden" name="action" value="create_user">
                <?= csrf_input(); ?>
                <div>
                    <label class="input-label" for="user-name">Nome</label>
                    <input class="input-control" id="user-name" name="name" required>
                </div>
                <div>
                    <label class="input-label" for="user-email">E-mail</label>
                    <input class="input-control" id="user-email" type="email" name="email" required>
                </div>
                <div>
                    <label class="input-label" for="user-role">Perfil</label>
                    <select class="select-control" id="user-role" name="role_id" required>
                        <?php foreach ($roles as $role): ?>
                            <option value="<?= (int) $role['id']; ?>"><?= htmlspecialchars($role['name'], ENT_QUOTES, 'UTF-8'); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label class="input-label" for="user-queue">Fila</label>
                    <select class="select-control" id="user-queue" name="queue_id">
                        <option value="">Nenhuma</option>
                        <?php foreach ($queues as $queue): ?>
                            <option value="<?= (int) $queue['id']; ?>"><?= htmlspecialchars($queue['name'], ENT_QUOTES, 'UTF-8'); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label class="input-label" for="user-phone">Telefone</label>
                    <input class="input-control" id="user-phone" name="phone">
                </div>
                <div>
                    <label class="input-label" for="user-password">Senha</label>
                    <input class="input-control" id="user-password" type="password" name="password" required>
                </div>
                <label class="checkbox-control">
                    <input type="checkbox" name="is_active" value="1" checked>
                    <span>Usuário ativo</span>
                </label>
                <div style="align-self:flex-end;">
                    <button class="btn" type="submit">Criar usuário</button>
                </div>
            </form>
        </div>
    </div>

    <div class="card card--elevated">
        <div class="card__title">Audit Log</div>
        <table class="data-table">
            <thead>
                <tr>
                    <th>Data</th>
                    <th>Usuário</th>
                    <th>Entidade</th>
                    <th>Ação</th>
                    <th>Payload</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($auditLogs as $log): ?>
                    <tr>
                        <td><?= htmlspecialchars(date('d/m/Y H:i', strtotime((string) $log['created_at'])), ENT_QUOTES, 'UTF-8'); ?></td>
                        <td><?= htmlspecialchars($log['user_name'] ?? 'Sistema', ENT_QUOTES, 'UTF-8'); ?></td>
                        <td><?= htmlspecialchars($log['entity'], ENT_QUOTES, 'UTF-8'); ?><?= $log['entity_id'] ? ' #' . (int) $log['entity_id'] : ''; ?></td>
                        <td><?= htmlspecialchars($log['action'], ENT_QUOTES, 'UTF-8'); ?></td>
                        <td>
                            <?php if (!empty($log['payload'])): ?>
                                <code style="font-size:0.8rem;"><?= htmlspecialchars(json_encode($log['payload'], JSON_UNESCAPED_UNICODE), ENT_QUOTES, 'UTF-8'); ?></code>
                            <?php else: ?>
                                <span class="muted">-</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                <?php if (empty($auditLogs)): ?>
                    <tr><td colspan="5" style="text-align:center;padding:1rem;">Nenhuma alteração registrada.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</section>
