<?php
$flashMessage = $flash['success'] ?? null;
$errors = $errors ?? [];
$adminSection = $adminSection ?? 'queues';
$old = $old ?? [];
$queueRecord = $queueRecord ?? null;
$formTitle = $formTitle ?? 'Nova fila';
$formAction = $formAction ?? app_url('admin/queues/store');
$isEdit = $isEdit ?? false;

$formData = $queueRecord !== null ? $queueRecord : [];
if (!empty($old)) {
    $formData = array_merge($formData, $old);
}

$isActive = array_key_exists('is_active', $formData)
    ? (int) $formData['is_active'] === 1
    : true;
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Administração</p>
            <h1 class="page__title"><?= htmlspecialchars($formTitle, ENT_QUOTES, 'UTF-8'); ?></h1>
            <p class="page__subtitle"><?= $isEdit ? 'Atualize parâmetros da fila selecionada.' : 'Cadastre uma nova fila do helpdesk.'; ?></p>
        </div>
        <div>
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/queues'), ENT_QUOTES, 'UTF-8'); ?>">Voltar para a lista</a>
        </div>
    </div>
    <?php include APP_PATH . '/Views/admin/nav.php'; ?>

    <?php if ($flashMessage): ?>
        <div class="alert alert--info"><?= htmlspecialchars($flashMessage, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>
    <?php if (!empty($errors)): ?>
        <div class="alert alert--error">
            <?php foreach ($errors as $error): ?>
                <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <div class="card__title"><?= htmlspecialchars($formTitle, ENT_QUOTES, 'UTF-8'); ?></div>
        <form method="post" action="<?= htmlspecialchars($formAction, ENT_QUOTES, 'UTF-8'); ?>" class="form-grid">
            <?= csrf_input(); ?>
            <div>
                <label class="input-label" for="queue-name">Nome da fila</label>
                <input class="input-control" id="queue-name" name="name" required minlength="3" value="<?= htmlspecialchars($formData['name'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div>
                <label class="input-label" for="queue-slug">Slug/código</label>
                <input class="input-control" id="queue-slug" name="slug" required minlength="3" value="<?= htmlspecialchars($formData['slug'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" placeholder="Ex: central-ti">
                <small class="muted">Somente letras, números, hífen ou underline.</small>
            </div>
            <div style="grid-column:1 / -1;">
                <label class="input-label" for="queue-desc">Descrição (opcional)</label>
                <textarea class="textarea-control" id="queue-desc" name="description" rows="2"><?= htmlspecialchars($formData['description'] ?? '', ENT_QUOTES, 'UTF-8'); ?></textarea>
            </div>
            <div>
                <label class="input-label" for="queue-response">SLA resposta (minutos)</label>
                <input class="input-control" id="queue-response" type="number" min="0" name="sla_response_minutes" value="<?= htmlspecialchars((string) ($formData['sla_response_minutes'] ?? 0), ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div>
                <label class="input-label" for="queue-resolution">SLA resolução (minutos)</label>
                <input class="input-control" id="queue-resolution" type="number" min="0" name="sla_resolution_minutes" value="<?= htmlspecialchars((string) ($formData['sla_resolution_minutes'] ?? 0), ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <label class="checkbox-control" style="margin-top:0.5rem;">
                <input type="checkbox" name="is_active" value="1"<?= $isActive ? ' checked' : ''; ?>>
                <span>Fila ativa</span>
            </label>
            <div style="align-self:flex-end;">
                <button class="btn" type="submit"><?= $isEdit ? 'Salvar alterações' : 'Criar fila'; ?></button>
            </div>
        </form>
    </div>
</section>
