<?php
$flashMessage = $flash['success'] ?? null;
$errors = $errors ?? [];
$adminSection = $adminSection ?? 'sla';
$old = $old ?? [];
$slaRecord = $slaRecord ?? null;
$formTitle = $formTitle ?? 'Novo SLA';
$formAction = $formAction ?? app_url('admin/slas/store');
$isEdit = $isEdit ?? false;
$priorities = $priorities ?? [];

$formData = $slaRecord !== null ? $slaRecord : [];
if (!empty($old)) {
    $formData = array_merge($formData, $old);
}

$businessHoursOnly = (int) ($formData['business_hours_only'] ?? 0) === 1;
$escalationEnabled = (int) ($formData['escalation_enabled'] ?? 0) === 1;
$isActive = array_key_exists('is_active', $formData)
    ? (int) $formData['is_active'] === 1
    : true;

$escalationMinutesValue = $formData['escalation_minutes'] ?? '';
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Administração</p>
            <h1 class="page__title"><?= htmlspecialchars($formTitle, ENT_QUOTES, 'UTF-8'); ?></h1>
            <p class="page__subtitle"><?= $isEdit ? 'Revise e atualize os parâmetros do SLA selecionado.' : 'Configure tempos e regras para um novo SLA.'; ?></p>
        </div>
        <div>
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/slas'), ENT_QUOTES, 'UTF-8'); ?>">Voltar para a lista</a>
        </div>
    </div>
    <?php include APP_PATH . '/Views/admin/nav.php'; ?>

    <?php if ($flashMessage): ?>
        <div class="alert alert--info"><?= htmlspecialchars($flashMessage, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>
    <?php if (!empty($errors)): ?>
        <div class="alert alert--error">
            <?php foreach ($errors as $error): ?>
                <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <div class="card__title"><?= htmlspecialchars($formTitle, ENT_QUOTES, 'UTF-8'); ?></div>
        <form method="post" action="<?= htmlspecialchars($formAction, ENT_QUOTES, 'UTF-8'); ?>" class="form-grid">
            <?= csrf_input(); ?>
            <div>
                <label class="input-label" for="sla-name">Nome do SLA</label>
                <input class="input-control" id="sla-name" name="name" required minlength="3" value="<?= htmlspecialchars($formData['name'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div>
                <label class="input-label" for="sla-priority">Prioridade associada</label>
                <select class="select-control" id="sla-priority" name="priority_id">
                    <option value="">Sem vínculo</option>
                    <?php foreach ($priorities as $priority): ?>
                        <option value="<?= (int) $priority['id']; ?>"<?= (int) ($formData['priority_id'] ?? 0) === (int) $priority['id'] ? ' selected' : ''; ?>>
                            <?= htmlspecialchars($priority['name'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div style="grid-column:1 / -1;">
                <label class="input-label" for="sla-description">Descrição (opcional)</label>
                <textarea class="input-control" id="sla-description" name="description" rows="3" placeholder="Adicione detalhes, escopo ou observações."><?= htmlspecialchars($formData['description'] ?? '', ENT_QUOTES, 'UTF-8'); ?></textarea>
            </div>
            <div>
                <label class="input-label" for="sla-first-response">Tempo para 1ª resposta (minutos)</label>
                <input class="input-control" id="sla-first-response" type="number" name="first_response_minutes" min="1" required value="<?= htmlspecialchars((string) ($formData['first_response_minutes'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div>
                <label class="input-label" for="sla-resolution">Tempo para resolução (minutos)</label>
                <input class="input-control" id="sla-resolution" type="number" name="resolution_minutes" min="1" required value="<?= htmlspecialchars((string) ($formData['resolution_minutes'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <label class="checkbox-control" style="margin-top:0.5rem;">
                <input type="checkbox" name="business_hours_only" value="1"<?= $businessHoursOnly ? ' checked' : ''; ?>>
                <span>Considerar apenas horário comercial</span>
            </label>
            <label class="checkbox-control" style="margin-top:0.5rem;">
                <input type="checkbox" name="escalation_enabled" value="1"<?= $escalationEnabled ? ' checked' : ''; ?>>
                <span>Ativar escalonamento automático</span>
            </label>
            <div>
                <label class="input-label" for="sla-escalation-minutes">Escalonar após (minutos)</label>
                <input class="input-control" id="sla-escalation-minutes" type="number" name="escalation_minutes" min="1"<?= $escalationEnabled ? ' required' : ''; ?> value="<?= htmlspecialchars((string) $escalationMinutesValue, ENT_QUOTES, 'UTF-8'); ?>">
                <small class="muted">Exigido somente quando o escalonamento estiver habilitado.</small>
            </div>
            <label class="checkbox-control" style="margin-top:0.5rem;">
                <input type="checkbox" name="is_active" value="1"<?= $isActive ? ' checked' : ''; ?>>
                <span>SLA ativo</span>
            </label>
            <div style="align-self:flex-end;">
                <button class="btn" type="submit"><?= $isEdit ? 'Salvar alterações' : 'Criar SLA'; ?></button>
            </div>
        </form>
    </div>
</section>
