<?php
$flashMessage = $flash['success'] ?? null;
$errors = $errors ?? [];
$slas = $slas ?? [];
$filters = $filters ?? ['q' => '', 'status' => 'all'];
$pagination = $pagination ?? ['page' => 1, 'pages' => 1, 'total' => 0];
$adminSection = $adminSection ?? 'sla';

$queryBase = [];
if (!empty($filters['q'])) {
    $queryBase['q'] = $filters['q'];
}
if (!empty($filters['status']) && $filters['status'] !== 'all') {
    $queryBase['status'] = $filters['status'];
}

$buildUrl = static function (array $baseQuery, int $page): string {
    if ($page > 1) {
        $baseQuery['page'] = $page;
    } else {
        unset($baseQuery['page']);
    }

    $queryString = http_build_query($baseQuery);
    $suffix = $queryString !== '' ? '?' . $queryString : '';

    return app_url('admin/slas' . $suffix);
};

$currentPage = max(1, (int) ($pagination['page'] ?? 1));
$currentRedirect = $buildUrl($queryBase, $currentPage);
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Administração</p>
            <h1 class="page__title">SLAs</h1>
            <p class="page__subtitle">Configure tempos de resposta e resolução do helpdesk.</p>
        </div>
        <div>
            <a class="btn" href="<?= htmlspecialchars(app_url('admin/slas/create'), ENT_QUOTES, 'UTF-8'); ?>">Novo SLA</a>
        </div>
    </div>
    <?php include APP_PATH . '/Views/admin/nav.php'; ?>

    <?php if ($flashMessage): ?>
        <div class="alert alert--info"><?= htmlspecialchars($flashMessage, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>
    <?php if (!empty($errors)): ?>
        <div class="alert alert--error">
            <?php foreach ($errors as $error): ?>
                <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <div class="card__title">Filtros</div>
        <form method="get" action="<?= htmlspecialchars(app_url('admin/slas'), ENT_QUOTES, 'UTF-8'); ?>" class="form-grid" style="align-items:flex-end;">
            <div>
                <label class="input-label" for="filter-q">Buscar por nome</label>
                <input class="input-control" id="filter-q" name="q" value="<?= htmlspecialchars($filters['q'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" placeholder="Ex: SLA Padrão">
            </div>
            <div>
                <label class="input-label" for="filter-status">Status</label>
                <select class="select-control" id="filter-status" name="status">
                    <option value="all"<?= ($filters['status'] ?? 'all') === 'all' ? ' selected' : ''; ?>>Todos</option>
                    <option value="active"<?= ($filters['status'] ?? 'all') === 'active' ? ' selected' : ''; ?>>Ativos</option>
                    <option value="inactive"<?= ($filters['status'] ?? 'all') === 'inactive' ? ' selected' : ''; ?>>Inativos</option>
                </select>
            </div>
            <div style="align-self:flex-end;">
                <button class="btn" type="submit">Filtrar</button>
            </div>
        </form>
    </div>

    <div class="card">
        <div class="card__title">SLAs cadastrados</div>
        <div class="data-table__wrapper">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>1ª resposta</th>
                        <th>Resolução</th>
                        <th>Horário comercial</th>
                        <th>Status</th>
                        <th style="width:180px;">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($slas as $sla): ?>
                        <?php
                            $isActive = (int) ($sla['is_active'] ?? 0) === 1;
                            $toggleLabel = $isActive ? 'Inativar' : 'Ativar';
                            $toggleValue = $isActive ? 0 : 1;
                            $toggleClass = $isActive ? 'btn--warning' : 'btn--ghost';
                        ?>
                        <tr>
                            <td>
                                <strong><?= htmlspecialchars($sla['name'], ENT_QUOTES, 'UTF-8'); ?></strong><br>
                                <small class="muted"><?= htmlspecialchars($sla['description'] ?? 'Sem descrição', ENT_QUOTES, 'UTF-8'); ?></small>
                            </td>
                            <td><?= (int) $sla['first_response_minutes']; ?> min</td>
                            <td><?= (int) $sla['resolution_minutes']; ?> min</td>
                            <td><?= ((int) ($sla['business_hours_only'] ?? 0)) === 1 ? 'Sim' : 'Não'; ?></td>
                            <td>
                                <span class="badge <?= $isActive ? 'badge--success' : 'badge--secondary'; ?>">
                                    <?= $isActive ? 'Ativo' : 'Inativo'; ?>
                                </span>
                            </td>
                            <?php
                                $toggleStyle = $isActive
                                    ? 'background-color:#E67E22;border:1px solid #E67E22;color:#ffffff;'
                                    : 'background-color:#1D4ED8;border:1px solid #1D4ED8;color:#ffffff;';
                            ?>
                            <td>
                                <div class="action-buttons" style="display:flex; gap:6px; align-items:center; flex-wrap:nowrap;">
                                    <a class="btn btn--sm btn--outline" href="<?= htmlspecialchars(app_url('admin/slas/edit?id=' . (int) $sla['id']), ENT_QUOTES, 'UTF-8'); ?>">Editar</a>
                                    <form method="post" action="<?= htmlspecialchars(app_url('admin/slas/toggle?id=' . (int) $sla['id']), ENT_QUOTES, 'UTF-8'); ?>" style="margin:0; display:inline-block;">
                                        <?= csrf_input(); ?>
                                        <input type="hidden" name="status" value="<?= $toggleValue; ?>">
                                        <input type="hidden" name="redirect" value="<?= htmlspecialchars('admin/slas' . (strpos($currentRedirect, '?') !== false ? substr($currentRedirect, strpos($currentRedirect, '?')) : ''), ENT_QUOTES, 'UTF-8'); ?>">
                                        <button
                                            class="btn btn--sm"
                                            type="submit"
                                            style="<?= $toggleStyle; ?>"
                                        ><?= htmlspecialchars($toggleLabel, ENT_QUOTES, 'UTF-8'); ?></button>
                                    </form>
                                    <form
                                        method="post"
                                        action="<?= htmlspecialchars(app_url('admin/slas/delete?id=' . (int) $sla['id']), ENT_QUOTES, 'UTF-8'); ?>"
                                        onsubmit="return confirm('Tem certeza que deseja excluir?');"
                                        style="margin:0; display:inline-block;"
                                    >
                                        <?= csrf_input(); ?>
                                        <input type="hidden" name="redirect" value="<?= htmlspecialchars('admin/slas' . (strpos($currentRedirect, '?') !== false ? substr($currentRedirect, strpos($currentRedirect, '?')) : ''), ENT_QUOTES, 'UTF-8'); ?>">
                                        <button
                                            class="btn btn--sm"
                                            type="submit"
                                            style="background-color:#C0392B;border:1px solid #C0392B;color:#ffffff;"
                                        >Excluir</button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (empty($slas)): ?>
                        <tr>
                            <td colspan="6" style="text-align:center;padding:1rem;">Nenhum SLA encontrado.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <?php if (($pagination['pages'] ?? 1) > 1): ?>
            <nav class="pagination">
                <?php if ($currentPage > 1): ?>
                    <a class="pagination__link" href="<?= htmlspecialchars($buildUrl($queryBase, $currentPage - 1), ENT_QUOTES, 'UTF-8'); ?>">&laquo; Anterior</a>
                <?php endif; ?>
                <span class="pagination__current">Página <?= (int) $currentPage; ?> de <?= (int) ($pagination['pages'] ?? 1); ?></span>
                <?php if ($currentPage < ($pagination['pages'] ?? 1)): ?>
                    <a class="pagination__link" href="<?= htmlspecialchars($buildUrl($queryBase, $currentPage + 1), ENT_QUOTES, 'UTF-8'); ?>">Próxima &raquo;</a>
                <?php endif; ?>
            </nav>
        <?php endif; ?>
    </div>
</section>
