<?php
$flashMessage = $flash['success'] ?? null;
$errors = $errors ?? [];
$theme = $theme ?? [];
$adminSection = $adminSection ?? 'theme';
$logoRelativePath = $theme['logo_path'] ?? null;
$logoUrl = null;
if (!empty($logoRelativePath)) {
    $logoFile = BASE_PATH . '/public/' . ltrim((string) $logoRelativePath, '/');
    if (is_file($logoFile)) {
        $logoUrl = asset_url($logoRelativePath);
    }
}
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Administração</p>
            <h1 class="page__title">Tema e Branding</h1>
            <p class="page__subtitle">Personalize cores e identificação visual para cada unidade.</p>
        </div>
    </div>
    <?php include APP_PATH . '/Views/admin/nav.php'; ?>

    <style>
        .color-picker-field {
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .color-input-hidden {
            position: absolute;
            left: -9999px;
            width: 1px;
            height: 1px;
            opacity: 0;
        }

        .color-picker-field__trigger {
            border: 1px solid #d9d9d9;
            background: #f8f8f8;
            border-radius: 6px;
            padding: 0.35rem 0.6rem;
            font-size: 1.25rem;
            line-height: 1;
            cursor: pointer;
            transition: background-color 0.2s ease, border-color 0.2s ease;
        }

        .color-picker-field__trigger:hover,
        .color-picker-field__trigger:focus-visible {
            background-color: #fff;
            border-color: #bdbdbd;
        }

        .color-preview {
            width: 28px;
            height: 28px;
            border-radius: 6px;
            border: 1px solid #d9d9d9;
            box-shadow: inset 0 0 0 1px rgba(0, 0, 0, 0.04);
            display: inline-block;
            flex-shrink: 0;
            cursor: pointer;
        }

        .color-picker-field__hex {
            flex: 1;
        }

        .input-control.is-invalid {
            border-color: #e74c3c;
        }

        .logo-card {
            display: flex;
            gap: 1.5rem;
            flex-wrap: wrap;
            align-items: flex-start;
        }

        .logo-preview-box {
            width: 240px;
            height: 90px;
            border: 1px dashed #c8c8c8;
            border-radius: 8px;
            background: #f8f8f8;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .logo-preview-box img {
            max-width: 220px;
            max-height: 80px;
            object-fit: contain;
        }

        .logo-actions form {
            margin-bottom: 0.75rem;
        }
    </style>

    <?php if ($flashMessage): ?>
        <div class="alert alert--info"><?= htmlspecialchars($flashMessage, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>
    <?php if (!empty($errors)): ?>
        <div class="alert alert--error">
            <?php foreach ($errors as $error): ?>
                <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <h2 class="card__title">Identidade visual</h2>
        <form method="post" action="<?= htmlspecialchars(app_url('admin'), ENT_QUOTES, 'UTF-8'); ?>" class="form-grid">
            <input type="hidden" name="action" value="update_theme">
            <?= csrf_input(); ?>
            <div>
                <label class="input-label" for="primary-color">Cor primária</label>
                <div class="color-picker-field" data-color-picker-field>
                    <input class="color-input-hidden" type="color" id="primary-color-picker" value="<?= htmlspecialchars($theme['primary_color'] ?? '#ff7a18', ENT_QUOTES, 'UTF-8'); ?>" data-color-native>
                    <label class="color-preview" data-color-preview for="primary-color-picker" aria-label="Pré-visualização da cor primária (clique para alterar)" title="Clique para alterar a cor" style="background-color: <?= htmlspecialchars($theme['primary_color'] ?? '#ff7a18', ENT_QUOTES, 'UTF-8'); ?>;"></label>
                    <input class="input-control color-picker-field__hex" id="primary-color" name="primary_color" type="text" value="<?= htmlspecialchars($theme['primary_color'] ?? '#ff7a18', ENT_QUOTES, 'UTF-8'); ?>" maxlength="7" placeholder="#RRGGBB" pattern="^#?[0-9A-Fa-f]{6}$" spellcheck="false" data-color-hex>
                </div>
            </div>
            <div>
                <label class="input-label" for="secondary-color">Cor secundária</label>
                <div class="color-picker-field" data-color-picker-field>
                    <input class="color-input-hidden" type="color" id="secondary-color-picker" value="<?= htmlspecialchars($theme['secondary_color'] ?? '#6c63ff', ENT_QUOTES, 'UTF-8'); ?>" data-color-native>
                    <label class="color-preview" data-color-preview for="secondary-color-picker" aria-label="Pré-visualização da cor secundária (clique para alterar)" title="Clique para alterar a cor" style="background-color: <?= htmlspecialchars($theme['secondary_color'] ?? '#6c63ff', ENT_QUOTES, 'UTF-8'); ?>;"></label>
                    <input class="input-control color-picker-field__hex" id="secondary-color" name="secondary_color" type="text" value="<?= htmlspecialchars($theme['secondary_color'] ?? '#6c63ff', ENT_QUOTES, 'UTF-8'); ?>" maxlength="7" placeholder="#RRGGBB" pattern="^#?[0-9A-Fa-f]{6}$" spellcheck="false" data-color-hex>
                </div>
            </div>
            <div>
                <label class="input-label" for="dark-color">Cor dark</label>
                <div class="color-picker-field" data-color-picker-field>
                    <input class="color-input-hidden" type="color" id="dark-color-picker" value="<?= htmlspecialchars($theme['dark_color'] ?? '#1f1f1f', ENT_QUOTES, 'UTF-8'); ?>" data-color-native>
                    <label class="color-preview" data-color-preview for="dark-color-picker" aria-label="Pré-visualização da cor dark (clique para alterar)" title="Clique para alterar a cor" style="background-color: <?= htmlspecialchars($theme['dark_color'] ?? '#1f1f1f', ENT_QUOTES, 'UTF-8'); ?>;"></label>
                    <input class="input-control color-picker-field__hex" id="dark-color" name="dark_color" type="text" value="<?= htmlspecialchars($theme['dark_color'] ?? '#1f1f1f', ENT_QUOTES, 'UTF-8'); ?>" maxlength="7" placeholder="#RRGGBB" pattern="^#?[0-9A-Fa-f]{6}$" spellcheck="false" data-color-hex>
                </div>
            </div>
            <div>
                <label class="input-label" for="accent-color">Cor de destaque</label>
                <div class="color-picker-field" data-color-picker-field>
                    <input class="color-input-hidden" type="color" id="accent-color-picker" value="<?= htmlspecialchars($theme['accent_color'] ?? '#37474f', ENT_QUOTES, 'UTF-8'); ?>" data-color-native>
                    <label class="color-preview" data-color-preview for="accent-color-picker" aria-label="Pré-visualização da cor de destaque (clique para alterar)" title="Clique para alterar a cor" style="background-color: <?= htmlspecialchars($theme['accent_color'] ?? '#37474f', ENT_QUOTES, 'UTF-8'); ?>;"></label>
                    <input class="input-control color-picker-field__hex" id="accent-color" name="accent_color" type="text" value="<?= htmlspecialchars($theme['accent_color'] ?? '#37474f', ENT_QUOTES, 'UTF-8'); ?>" maxlength="7" placeholder="#RRGGBB" pattern="^#?[0-9A-Fa-f]{6}$" spellcheck="false" data-color-hex>
                </div>
            </div>
            <div>
                <label class="input-label" for="logo-text">Texto da marca</label>
                <input class="input-control" id="logo-text" name="logo_text" value="<?= htmlspecialchars($theme['logo_text'] ?? 'HelpDesk', ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div style="align-self:flex-end;">
                <button class="btn" type="submit">Salvar tema</button>
            </div>
        </form>
    </div>

    <div class="card">
        <h2 class="card__title">Logo do sistema</h2>
        <div class="logo-card">
            <div>
                <div class="logo-preview-box">
                    <?php if ($logoUrl): ?>
                        <img src="<?= htmlspecialchars($logoUrl, ENT_QUOTES, 'UTF-8'); ?>" alt="Logo atual" loading="lazy">
                    <?php else: ?>
                        <span class="muted">Nenhuma logo enviada.</span>
                    <?php endif; ?>
                </div>
                <p class="muted" style="margin-top:0.5rem;">Formatos aceitos: JPG, JPEG ou PNG. Máximo 2MB.</p>
            </div>
            <div class="logo-actions" style="flex:1;min-width:240px;">
                <form method="post" action="<?= htmlspecialchars(app_url('admin/theme/logo'), ENT_QUOTES, 'UTF-8'); ?>" enctype="multipart/form-data">
                    <?= csrf_input(); ?>
                    <label class="input-label" for="theme-logo-input">Selecione uma logo</label>
                    <input class="input-control" id="theme-logo-input" type="file" name="logo" accept="image/png,image/jpeg" required>
                    <small class="muted">A imagem será ajustada automaticamente para caber em 220x60 px.</small>
                    <div style="margin-top:0.75rem;">
                        <button class="btn" type="submit"><?= $logoUrl ? 'Atualizar logo' : 'Enviar logo'; ?></button>
                    </div>
                </form>
                <?php if ($logoUrl): ?>
                    <form method="post" action="<?= htmlspecialchars(app_url('admin/theme/logo/remove'), ENT_QUOTES, 'UTF-8'); ?>" onsubmit="return confirm('Remover logo atual?');">
                        <?= csrf_input(); ?>
                        <button class="btn btn--ghost" type="submit">Remover logo</button>
                    </form>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="card card--gradient">
        <div class="card__title">Prévia</div>
        <div style="display:flex;flex-wrap:wrap;gap:1.5rem;">
            <div style="flex:1;">
                <p class="muted">Marca</p>
                <div class="brand">
                    <span class="brand__mark" style="background: linear-gradient(135deg, <?= htmlspecialchars($theme['primary_color'] ?? '#ff7a18', ENT_QUOTES, 'UTF-8'); ?>, <?= htmlspecialchars($theme['secondary_color'] ?? '#6c63ff', ENT_QUOTES, 'UTF-8'); ?>);"></span>
                    <span class="brand__name"><?= htmlspecialchars($theme['logo_text'] ?? 'HelpDesk', ENT_QUOTES, 'UTF-8'); ?></span>
                </div>
            </div>
            <div style="flex:1;">
                <p class="muted">Botões</p>
                <div style="display:flex;gap:0.5rem;">
                    <button class="btn" type="button" style="background: <?= htmlspecialchars($theme['primary_color'] ?? '#ff7a18', ENT_QUOTES, 'UTF-8'); ?>;">Primário</button>
                    <button class="btn btn--secondary" type="button" style="background: <?= htmlspecialchars($theme['secondary_color'] ?? '#6c63ff', ENT_QUOTES, 'UTF-8'); ?>;">Secundário</button>
                </div>
            </div>
        </div>
    </div>
</section>

<script defer src="<?= htmlspecialchars(asset_url('assets/js/admin-theme.js'), ENT_QUOTES, 'UTF-8'); ?>"></script>
