<?php
$flashMessage = $flash['success'] ?? null;
$errors = $errors ?? [];
$userRecord = $userRecord ?? null;
$adminSection = $adminSection ?? 'users';
if ($userRecord === null) {
    $userRecord = ['name' => '-', 'email' => '-'];
}
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Administração</p>
            <h1 class="page__title">Excluir usuário</h1>
            <p class="page__subtitle">Confirme a remoção do usuário. Esta ação pode ser revertida reativando o cadastro futuramente.</p>
        </div>
        <div>
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/users'), ENT_QUOTES, 'UTF-8'); ?>">Voltar para a lista</a>
        </div>
    </div>
    <?php include APP_PATH . '/Views/admin/nav.php'; ?>

    <?php if ($flashMessage): ?>
        <div class="alert alert--info"><?= htmlspecialchars($flashMessage, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>
    <?php if (!empty($errors)): ?>
        <div class="alert alert--error">
            <?php foreach ($errors as $error): ?>
                <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <div class="card__title">Confirmação</div>
        <p>Tem certeza que deseja remover o usuário <strong><?= htmlspecialchars($userRecord['name'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></strong> (<em><?= htmlspecialchars($userRecord['email'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></em>)?</p>
        <p class="muted">O usuário será desativado e ocultado das listagens, mas poderá ser reativado posteriormente por um gestor.</p>
        <form method="post" action="<?= htmlspecialchars(app_url('admin/users/delete?id=' . (int) ($userRecord['id'] ?? 0)), ENT_QUOTES, 'UTF-8'); ?>" style="display:flex;gap:0.5rem;flex-wrap:wrap;">
            <?= csrf_input(); ?>
            <button class="btn btn--outline" type="submit">Confirmar exclusão</button>
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/users'), ENT_QUOTES, 'UTF-8'); ?>">Cancelar</a>
        </form>
    </div>
</section>
