<?php
$flashMessage = $flash['success'] ?? null;
$errors = $errors ?? [];
$roles = $roles ?? [];
$queues = $queues ?? [];
$adminSection = $adminSection ?? 'users';
$old = $old ?? [];
$userRecord = $userRecord ?? null;
$isEdit = $isEdit ?? false;
$formTitle = $formTitle ?? ($isEdit ? 'Editar usuário' : 'Novo usuário');
$formAction = $formAction ?? app_url('admin/users/store');

$formData = $userRecord !== null ? $userRecord : [];
if (!empty($old)) {
    $formData = array_merge($formData, $old);
}

$isActive = array_key_exists('is_active', $formData)
    ? (int) $formData['is_active'] === 1
    : true;
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Administração</p>
            <h1 class="page__title"><?= htmlspecialchars($formTitle, ENT_QUOTES, 'UTF-8'); ?></h1>
            <p class="page__subtitle"><?= $isEdit ? 'Atualize os dados do usuário selecionado.' : 'Preencha os dados para criar um novo usuário.'; ?></p>
        </div>
        <div>
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('admin/users'), ENT_QUOTES, 'UTF-8'); ?>">Voltar para a lista</a>
        </div>
    </div>
    <?php include APP_PATH . '/Views/admin/nav.php'; ?>

    <?php if ($flashMessage): ?>
        <div class="alert alert--info"><?= htmlspecialchars($flashMessage, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>
    <?php if (!empty($errors)): ?>
        <div class="alert alert--error">
            <?php foreach ($errors as $error): ?>
                <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <div class="card__title"><?= htmlspecialchars($formTitle, ENT_QUOTES, 'UTF-8'); ?></div>
        <form method="post" action="<?= htmlspecialchars($formAction, ENT_QUOTES, 'UTF-8'); ?>" class="form-grid">
            <?= csrf_input(); ?>
            <div>
                <label class="input-label" for="user-name">Nome completo</label>
                <input class="input-control" id="user-name" name="name" required minlength="3" value="<?= htmlspecialchars($formData['name'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div>
                <label class="input-label" for="user-email">E-mail</label>
                <input class="input-control" id="user-email" name="email" type="email" required value="<?= htmlspecialchars($formData['email'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div>
                <label class="input-label" for="user-phone">Telefone (opcional)</label>
                <input class="input-control" id="user-phone" name="phone" value="<?= htmlspecialchars($formData['phone'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div>
                <label class="input-label" for="user-role">Perfil</label>
                <select class="select-control" id="user-role" name="role_id" required>
                    <option value="">Selecione</option>
                    <?php foreach ($roles as $role): ?>
                        <option value="<?= (int) $role['id']; ?>"<?= (int) ($formData['role_id'] ?? 0) === (int) $role['id'] ? ' selected' : ''; ?>>
                            <?= htmlspecialchars($role['name'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div>
                <label class="input-label" for="user-queue">Fila padrão</label>
                <select class="select-control" id="user-queue" name="queue_id">
                    <option value="">Sem fila</option>
                    <?php foreach ($queues as $queue): ?>
                        <option value="<?= (int) $queue['id']; ?>"<?= (int) ($formData['queue_id'] ?? 0) === (int) $queue['id'] ? ' selected' : ''; ?>>
                            <?= htmlspecialchars($queue['name'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div>
                <label class="input-label" for="user-password"><?= $isEdit ? 'Nova senha (opcional)' : 'Senha'; ?></label>
                <input class="input-control" id="user-password" type="password" name="password"<?= $isEdit ? '' : ' required'; ?> minlength="6" autocomplete="new-password">
            </div>
            <div>
                <label class="input-label" for="user-password-confirm">Confirmar senha</label>
                <input class="input-control" id="user-password-confirm" type="password" name="password_confirmation"<?= $isEdit ? '' : ' required'; ?> minlength="6" autocomplete="new-password">
                <?php if ($isEdit): ?>
                    <small class="muted">Preencha apenas se desejar alterar a senha.</small>
                <?php endif; ?>
            </div>
            <label class="checkbox-control" style="margin-top:0.5rem;">
                <input type="checkbox" name="is_active" value="1"<?= $isActive ? ' checked' : ''; ?>>
                <span>Usuário ativo</span>
            </label>
            <div style="align-self:flex-end;">
                <button class="btn" type="submit"><?= $isEdit ? 'Salvar alterações' : 'Criar usuário'; ?></button>
            </div>
        </form>
    </div>
</section>
<script>
    (function () {
        const passwordInput = document.getElementById('user-password');
        const confirmInput = document.getElementById('user-password-confirm');
        if (!passwordInput || !confirmInput) {
            return;
        }

        const helperButton = document.createElement('button');
        helperButton.type = 'button';
        helperButton.className = 'btn btn--ghost btn--sm';
        helperButton.textContent = 'Gerar senha segura';
        helperButton.style.marginTop = '0.25rem';

        helperButton.addEventListener('click', function () {
            const randomPassword = Math.random().toString(36).slice(-10) + 'A1!';
            passwordInput.value = randomPassword;
            confirmInput.value = randomPassword;
            alert('Senha temporária gerada. Salve para aplicá-la.');
        });

        const passwordField = passwordInput.parentElement;
        if (passwordField) {
            passwordField.appendChild(helperButton);
        }
    })();
</script>
