<?php
$themeVars = theme_variables();
$brandName = theme_brand();
$pageTitle = $pageTitle ?? $brandName;
$bodyClass = trim($bodyClass ?? '');
if ($bodyClass === '') {
    $bodyClass = 'layout layout--auth';
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($pageTitle, ENT_QUOTES, 'UTF-8'); ?></title>
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?= htmlspecialchars(asset_url('assets/css/app.css'), ENT_QUOTES, 'UTF-8'); ?>">
    <style>
        :root {
            <?php foreach ($themeVars as $variable => $value): ?>
            <?= $variable; ?>: <?= $value; ?>;
            <?php endforeach; ?>
        }
        .brand__logo {
            max-width: 160px;
            max-height: 60px;
            object-fit: contain;
            display: block;
        }
    </style>
</head>
<body class="<?= htmlspecialchars($bodyClass, ENT_QUOTES, 'UTF-8'); ?>">
    <header class="app-header app-header--auth">
        <div class="app-header__brand">
            <div class="brand">
                <?php $brandLogo = theme_logo_url(); ?>
                <?php if ($brandLogo): ?>
                    <img class="brand__logo" src="<?= htmlspecialchars($brandLogo, ENT_QUOTES, 'UTF-8'); ?>" alt="<?= htmlspecialchars($brandName, ENT_QUOTES, 'UTF-8'); ?>">
                <?php else: ?>
                    <span class="brand__mark"></span>
                <?php endif; ?>
                <span class="brand__name"><?= htmlspecialchars($brandName, ENT_QUOTES, 'UTF-8'); ?></span>
            </div>
        </div>
    </header>

    <main class="app-main app-main--auth">
        <?= $viewContent ?? ''; ?>
    </main>
</body>
</html>
