<?php
$userSession = auth_user();
$currentPath = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH) ?? '/';
$baseDir = $GLOBALS['app.base_dir'] ?? '';
if ($baseDir !== '' && str_starts_with($currentPath, $baseDir)) {
    $currentPath = substr($currentPath, strlen($baseDir));
    if ($currentPath === '') {
        $currentPath = '/';
    }
}
$normalize = static function (string $path): string {
    $normalized = '/' . ltrim($path, '/');
    return $normalized === '//minha-fila' ? '/minha-fila' : $normalized;
};
$myQueueLabel = ($userSession['role_name'] ?? '') === 'Solicitante Externo'
    ? 'Minhas Solicitações'
    : 'Minha Fila';

$links = [];

if ((string) ($userSession['role_slug'] ?? '') !== 'externo') {
    $links[] = [
        'label' => $myQueueLabel,
        'href' => app_url('tickets/minha-fila'),
        'path' => '/tickets/minha-fila',
    ];
}

$links[] = [
    'label' => 'Tickets',
    'href' => app_url('tickets'),
    'path' => '/tickets',
];
$links[] = [
    'label' => 'Relatórios',
    'href' => app_url('reports'),
    'path' => '/reports',
    'roles' => ['gestor'],
];
$links[] = [
    'label' => 'Admin',
    'href' => app_url('admin'),
    'path' => '/admin',
    'roles' => ['gestor'],
];
$links[] = [
    'label' => 'Logs',
    'href' => app_url('admin/logs'),
    'path' => '/admin/logs',
    'roles' => ['gestor'],
];
$currentPath = $normalize($currentPath);
$isAllowed = static function (?array $roles) use ($userSession): bool {
    if ($roles === null || $roles === []) {
        return true;
    }

    if ($userSession === null) {
        return false;
    }

    return in_array($userSession['role_slug'] ?? '', $roles, true);
};
?>
<nav class="topnav" data-topnav>
    <button
        class="topnav__toggle"
        type="button"
        data-topnav-toggle
        aria-expanded="false"
        aria-label="Alternar menu"
        aria-controls="app-topnav-list"
    >
        <span></span>
        <span></span>
        <span></span>
        <strong>Menu</strong>
    </button>
    <ul class="topnav__list" id="app-topnav-list" data-topnav-links>
        <?php foreach ($links as $link): ?>
            <?php if (!$isAllowed($link['roles'] ?? null)) continue; ?>
            <?php
                $path = $normalize($link['path'] ?? '/');
                $active = $currentPath === $path || ($path !== '/' && str_starts_with($currentPath, $path));
            ?>
            <li>
                <a
                    class="topnav__link<?= $active ? ' is-active' : ''; ?>"
                    href="<?= htmlspecialchars($link['href'], ENT_QUOTES, 'UTF-8'); ?>"
                >
                    <?= htmlspecialchars($link['label'], ENT_QUOTES, 'UTF-8'); ?>
                </a>
            </li>
        <?php endforeach; ?>
    </ul>
</nav>
<div class="topnav__backdrop" data-topnav-backdrop aria-hidden="true"></div>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const toggle = document.querySelector('[data-topnav-toggle]');
    const list = document.querySelector('[data-topnav-links]');
    const backdrop = document.querySelector('[data-topnav-backdrop]');
    if (!toggle || !list || !backdrop) {
        return;
    }

    const BREAKPOINT = 1024;
    let isOpen = false;

    const closeMenu = () => {
        isOpen = false;
        list.classList.remove('is-open');
        backdrop.classList.remove('is-visible');
        document.body.classList.remove('no-scroll');
        toggle.setAttribute('aria-expanded', 'false');
    };

    const openMenu = () => {
        isOpen = true;
        list.classList.add('is-open');
        backdrop.classList.add('is-visible');
        document.body.classList.add('no-scroll');
        toggle.setAttribute('aria-expanded', 'true');
    };

    const isMobile = () => window.innerWidth < BREAKPOINT;

    toggle.addEventListener('click', function () {
        if (!isMobile()) {
            return;
        }
        if (isOpen) {
            closeMenu();
        } else {
            openMenu();
        }
    });

    backdrop.addEventListener('click', closeMenu);

    list.querySelectorAll('a').forEach(function (link) {
        link.addEventListener('click', function () {
            if (isMobile()) {
                closeMenu();
            }
        });
    });

    document.addEventListener('keydown', function (event) {
        if (event.key === 'Escape' && isOpen) {
            closeMenu();
        }
    });

    window.addEventListener('resize', function () {
        if (!isMobile()) {
            closeMenu();
        }
    });
});
</script>
