<?php
$filters = $filters ?? ['from_date' => '', 'to_date' => ''];
$categoryPriority = $categoryPriority ?? [];
$typeBreakdown = $typeBreakdown ?? [];
$totalsByMain = $totalsByMain ?? [];
$averages = $averages ?? [];
$sla = $sla ?? ['met' => 0, 'breached' => 0];
$rankingAssignees = $rankingAssignees ?? [];
$rankingCustomers = $rankingCustomers ?? [];

$totalSla = max(1, (int) ($sla['met'] + $sla['breached']));
$slaMetPercent = round(($sla['met'] / $totalSla) * 100);
$slaBreachPercent = 100 - $slaMetPercent;
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Painel Executivo</p>
            <h1 class="page__title">Relatórios e KPIs</h1>
            <p class="page__subtitle">Analise volume por categoria, desempenho de SLA e rankings em um único lugar.</p>
        </div>
        <div class="page__actions">
            <form method="get" action="<?= htmlspecialchars(app_url('reports'), ENT_QUOTES, 'UTF-8'); ?>" class="filters-grid" style="grid-template-columns:repeat(auto-fit,minmax(160px,1fr));">
                <div>
                    <label class="input-label" for="from_date">De</label>
                    <input class="input-control" type="date" id="from_date" name="from_date" value="<?= htmlspecialchars((string) $filters['from_date'], ENT_QUOTES, 'UTF-8'); ?>">
                </div>
                <div>
                    <label class="input-label" for="to_date">Até</label>
                    <input class="input-control" type="date" id="to_date" name="to_date" value="<?= htmlspecialchars((string) $filters['to_date'], ENT_QUOTES, 'UTF-8'); ?>">
                </div>
                <div style="align-self:flex-end;">
                    <button class="btn" type="submit">Filtrar</button>
                </div>
            </form>
        </div>
    </div>

    <div class="grid-cards">
        <div class="card stat-card">
            <span class="badge badge--neutral">Média 1ª resposta</span>
            <div class="stat-card__value">
                <?= isset($averages['avg_response']) && $averages['avg_response'] !== null
                    ? htmlspecialchars(human_minutes((float) $averages['avg_response']), ENT_QUOTES, 'UTF-8')
                    : '--'; ?>
            </div>
            <small class="muted">Minutos</small>
        </div>
        <div class="card stat-card">
            <span class="badge badge--neutral">Média resolução</span>
            <div class="stat-card__value">
                <?= isset($averages['avg_resolution']) && $averages['avg_resolution'] !== null
                    ? htmlspecialchars(human_minutes((float) $averages['avg_resolution']), ENT_QUOTES, 'UTF-8')
                    : '--'; ?>
            </div>
            <small class="muted">Minutos</small>
        </div>
        <div class="card stat-card">
            <span class="badge badge--neutral">SLA atendido</span>
            <div class="stat-card__value"><?= $slaMetPercent; ?>%</div>
            <small class="muted"><?= (int) $sla['met']; ?> dentro da meta</small>
        </div>
        <div class="card stat-card">
            <span class="badge badge--neutral">SLA estourado</span>
            <div class="stat-card__value"><?= $slaBreachPercent; ?>%</div>
            <small class="muted"><?= (int) $sla['breached']; ?> fora da meta</small>
        </div>
    </div>

    <div class="responsive-stack">
        <div class="card">
            <div class="card__title">
                Fila por categoria e prioridade
                <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('reports/export?metric=category_priority&from_date=' . $filters['from_date'] . '&to_date=' . $filters['to_date']), ENT_QUOTES, 'UTF-8'); ?>">Exportar CSV</a>
            </div>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Categoria</th>
                        <th>Prioridade</th>
                        <th>Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($categoryPriority as $row): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['category_name'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?= htmlspecialchars($row['priority_name'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?= (int) $row['total']; ?></td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (empty($categoryPriority)): ?>
                        <tr><td colspan="3" style="text-align:center;padding:1rem;">Sem dados para o período.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="card">
            <div class="card__title">
                Chamados por tipo/subcategoria
                <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('reports/export?metric=type_subcategory&from_date=' . $filters['from_date'] . '&to_date=' . $filters['to_date']), ENT_QUOTES, 'UTF-8'); ?>">Exportar CSV</a>
            </div>
            <div class="report-list">
                <?php foreach ($typeBreakdown as $row): ?>
                    <?php
                        $type = $row['main_category'] ?? 'N/A';
                        $total = (int) ($row['total'] ?? 0);
                        $percent = isset($totalsByMain[$type]) && $totalsByMain[$type] > 0
                            ? round(($total / $totalsByMain[$type]) * 100)
                            : 0;
                    ?>
                    <div class="report-list__item">
                        <div>
                            <strong><?= htmlspecialchars($type, ENT_QUOTES, 'UTF-8'); ?></strong>
                            <p class="muted"><?= htmlspecialchars($row['subcategory'], ENT_QUOTES, 'UTF-8'); ?></p>
                        </div>
                        <div class="report-list__metric">
                            <span><?= $total; ?></span>
                            <small><?= $percent; ?>%</small>
                        </div>
                    </div>
                <?php endforeach; ?>
                <?php if (empty($typeBreakdown)): ?>
                    <p class="muted">Sem registros.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card__title">
            SLA atendido x não atendido
            <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('reports/export?metric=sla&from_date=' . $filters['from_date'] . '&to_date=' . $filters['to_date']), ENT_QUOTES, 'UTF-8'); ?>">Exportar CSV</a>
        </div>
        <div class="progress">
            <div class="progress__bar" style="width: <?= $slaMetPercent; ?>%; background: rgba(76, 175, 80, 0.8);">
                <span><?= $slaMetPercent; ?>% Dentro</span>
            </div>
            <div class="progress__bar" style="width: <?= $slaBreachPercent; ?>%; background: rgba(244, 67, 54, 0.8);">
                <span><?= $slaBreachPercent; ?>% Fora</span>
            </div>
        </div>
    </div>

    <div class="responsive-stack">
        <div class="card">
            <div class="card__title">
                Ranking por responsável
                <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('reports/export?metric=ranking_assignees&from_date=' . $filters['from_date'] . '&to_date=' . $filters['to_date']), ENT_QUOTES, 'UTF-8'); ?>">Exportar CSV</a>
            </div>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Responsável</th>
                        <th>Chamados</th>
                        <th>Média resolução</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($rankingAssignees as $row): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['assignee_name'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?= (int) $row['total_tickets']; ?></td>
                            <td>
                                <?= isset($row['avg_resolution']) && $row['avg_resolution'] !== null
                                    ? htmlspecialchars(human_minutes((float) $row['avg_resolution']), ENT_QUOTES, 'UTF-8')
                                    : '--'; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (empty($rankingAssignees)): ?>
                        <tr><td colspan="3" style="text-align:center;padding:1rem;">Sem responsáveis no período.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="card">
            <div class="card__title">
                Ranking por cliente/obra
                <a class="btn btn--ghost" href="<?= htmlspecialchars(app_url('reports/export?metric=ranking_customers&from_date=' . $filters['from_date'] . '&to_date=' . $filters['to_date']), ENT_QUOTES, 'UTF-8'); ?>">Exportar CSV</a>
            </div>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Cliente/Obra</th>
                        <th>Chamados</th>
                        <th>Média resolução</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($rankingCustomers as $row): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['customer_name'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?= (int) $row['total_tickets']; ?></td>
                            <td>
                                <?= isset($row['avg_resolution']) && $row['avg_resolution'] !== null
                                    ? htmlspecialchars(human_minutes((float) $row['avg_resolution']), ENT_QUOTES, 'UTF-8')
                                    : '--'; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (empty($rankingCustomers)): ?>
                        <tr><td colspan="3" style="text-align:center;padding:1rem;">Sem dados para o período.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</section>
