<?php
use App\Config\AppConfig;

$pageTitle = $pageTitle ?? ($mode === 'edit' ? 'Editar Chamado' : 'Novo Chamado');
$isEdit = ($mode ?? '') === 'edit';
$actionUrl = $isEdit
    ? app_url('tickets/update?id=' . ($ticket['id'] ?? ''))
    : app_url('tickets/store');
$users = $options['users'] ?? [];
$queues = $options['queues'] ?? [];
$categories = $options['categories'] ?? [];
$priorities = $options['priorities'] ?? [];
$statuses = $options['statuses'] ?? [];
$customerTypes = $options['customer_types'] ?? [];
$mainCategories = $options['main_categories'] ?? [];
$dynamicFieldCatalog = $dynamicFieldCatalog ?? [];
$fieldValues = $fieldValues ?? [];
$currentCategoryId = (int) ($ticket['category_id'] ?? 0);
$currentUser = $currentUser ?? auth_user();
$userRole = strtolower((string) ($currentUser['role_slug'] ?? ''));
$isExternal = $userRole === 'externo';
$externalClientTypeSlug = 'externo';
$externalClientTypeName = 'Externo';
if ($customerTypes !== []) {
    $firstType = $customerTypes[0];
    $externalClientTypeSlug = (string) ($firstType['slug'] ?? $externalClientTypeSlug);
    $externalClientTypeName = (string) ($firstType['name'] ?? $externalClientTypeName);
    foreach ($customerTypes as $candidateType) {
        $slug = (string) ($candidateType['slug'] ?? '');
        if (strcasecmp($slug, 'externo') === 0) {
            $externalClientTypeSlug = $slug;
            $externalClientTypeName = (string) ($candidateType['name'] ?? $externalClientTypeName);
            break;
        }
    }
}
$externalMainCategorySlug = 'ti';
$externalMainCategoryName = 'TI';
if ($mainCategories !== []) {
    $firstCategory = $mainCategories[0];
    $externalMainCategorySlug = (string) ($firstCategory['slug'] ?? $externalMainCategorySlug);
    $externalMainCategoryName = (string) ($firstCategory['name'] ?? $externalMainCategoryName);
    foreach ($mainCategories as $candidateCategory) {
        $slug = (string) ($candidateCategory['slug'] ?? '');
        if (strcasecmp($slug, 'ti') === 0) {
            $externalMainCategorySlug = $slug;
            $externalMainCategoryName = (string) ($candidateCategory['name'] ?? $externalMainCategoryName);
            break;
        }
    }
}
$externalQueueSlug = AppConfig::externalQueueSlug();
$externalQueue = null;
foreach ($queues as $queueOption) {
    if (strcasecmp((string) ($queueOption['slug'] ?? ''), $externalQueueSlug) === 0) {
        $externalQueue = $queueOption;
        break;
    }
}
$externalQueueId = $externalQueue !== null ? (int) $externalQueue['id'] : null;
$externalQueueName = $externalQueue['name'] ?? 'Central TI';
$externalAssigneeEmail = AppConfig::externalAssigneeEmail();
$externalAssignee = null;
foreach ($users as $userOption) {
    if (strcasecmp((string) ($userOption['email'] ?? ''), $externalAssigneeEmail) === 0) {
        $externalAssignee = $userOption;
        break;
    }
}
$externalAssigneeId = $externalAssignee !== null ? (int) $externalAssignee['id'] : null;
$externalAssigneeName = $externalAssignee['name'] ?? AppConfig::externalAssigneeLabel();

if (!function_exists('ticket_render_dynamic_fields')) {
    /**
     * @param array<int, array<string, mixed>> $fields
     * @param array<string, string> $values
     */
    function ticket_render_dynamic_fields(array $fields, array $values): string
    {
        if ($fields === []) {
            return '<p class="muted">Selecione uma subcategoria para liberar campos específicos.</p>';
        }

        ob_start();
        foreach ($fields as $field) {
            $name = (string) $field['name'];
            $label = htmlspecialchars((string) $field['label'], ENT_QUOTES, 'UTF-8');
            $required = !empty($field['is_required']);
            $value = $values[$name] ?? '';
            $inputId = 'field-' . htmlspecialchars($name, ENT_QUOTES, 'UTF-8');
            echo '<div class="dynamic-field" data-field-wrapper>';
            echo '<label class="input-label" for="' . $inputId . '">' . $label;
            echo $required ? ' <span style="color:var(--secondary);">*</span>' : '';
            echo '</label>';

            $safeName = htmlspecialchars($name, ENT_QUOTES, 'UTF-8');
            $safeValue = htmlspecialchars((string) $value, ENT_QUOTES, 'UTF-8');

            switch ($field['type']) {
                case 'textarea':
                    echo '<textarea class="textarea-control" id="' . $inputId . '" name="fields[' . $safeName . ']" '
                        . ($required ? 'required ' : '')
                        . 'data-field-name="' . $safeName . '">' . $safeValue . '</textarea>';
                    break;
                case 'select':
                    echo '<select class="select-control" id="' . $inputId . '" name="fields[' . $safeName . ']" '
                        . ($required ? 'required ' : '')
                        . 'data-field-name="' . $safeName . '">';
                    echo '<option value="">Selecione</option>';
                    $options = $field['options'] ?? [];
                    foreach ($options as $option) {
                        $optLabel = htmlspecialchars((string) $option, ENT_QUOTES, 'UTF-8');
                        $selected = ((string) $option === (string) $value) ? 'selected' : '';
                        echo '<option value="' . $optLabel . '" ' . $selected . '>' . $optLabel . '</option>';
                    }
                    echo '</select>';
                    break;
                case 'number':
                    echo '<input class="input-control" type="number" id="' . $inputId . '" name="fields[' . $safeName . ']" '
                        . ($required ? 'required ' : '')
                        . 'value="' . $safeValue . '" data-field-name="' . $safeName . '">';
                    break;
                case 'boolean':
                    echo '<label class="checkbox-control">';
                    echo '<input type="hidden" name="fields[' . $safeName . ']" value="0">';
                    $checked = ((string) $value === '1') ? 'checked' : '';
                    echo '<input type="checkbox" id="' . $inputId . '" name="fields[' . $safeName . ']" value="1" '
                        . $checked . ' data-field-name="' . $safeName . '">';
                    echo '<span>Sim</span>';
                    echo '</label>';
                    break;
                default:
                    echo '<input class="input-control" type="text" id="' . $inputId . '" name="fields[' . $safeName . ']" '
                        . ($required ? 'required ' : '')
                        . 'value="' . $safeValue . '" data-field-name="' . $safeName . '">';
                    break;
            }
            echo '</div>';
        }

        return (string) ob_get_clean();
    }
}
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--secondary"><?= $isEdit ? 'Edição' : 'Cadastro'; ?></p>
            <h1 class="page__title"><?= $isEdit ? htmlspecialchars($ticket['reference'], ENT_QUOTES, 'UTF-8') : 'Novo Chamado'; ?></h1>
            <p class="page__subtitle">Preencha as informações essenciais, defina prioridade e responsável.</p>
        </div>
        <div class="page__actions">
            <a class="btn btn--outline" href="<?= htmlspecialchars(app_url('tickets'), ENT_QUOTES, 'UTF-8'); ?>">Voltar</a>
        </div>
    </div>

    <?php if (!empty($errors)): ?>
        <div class="alert alert--error">
            <?php foreach ($errors as $error): ?>
                <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <form method="post" action="<?= htmlspecialchars($actionUrl, ENT_QUOTES, 'UTF-8'); ?>" class="card form-ticket">
        <?= csrf_input(); ?>
        <?php if (isset($ticket['id'])): ?>
            <input type="hidden" name="id" value="<?= (int) $ticket['id']; ?>">
        <?php endif; ?>
        <input type="hidden" name="requester_id" value="<?= htmlspecialchars((string) ($ticket['requester_id'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>">

        <div class="form-grid">
            <div>
                <label class="input-label" for="client_type">Tipo de cliente</label>
                <?php if ($isExternal): ?>
                    <input type="hidden" id="client_type" name="client_type" value="<?= htmlspecialchars($externalClientTypeSlug, ENT_QUOTES, 'UTF-8'); ?>">
                    <p class="muted"><?= htmlspecialchars($externalClientTypeName, ENT_QUOTES, 'UTF-8'); ?> (travado para seu perfil)</p>
                <?php else: ?>
                    <?php if ($customerTypes === []): ?>
                        <div class="alert alert--error" style="margin-top:0.5rem;">Nenhum tipo de cliente ativo. Cadastre em Administração &gt; Tipos de cliente.</div>
                    <?php else: ?>
                        <select class="select-control" id="client_type" name="client_type">
                            <?php foreach ($customerTypes as $typeOption): ?>
                                <option value="<?= htmlspecialchars((string) $typeOption['slug'], ENT_QUOTES, 'UTF-8'); ?>" <?= ((string) ($ticket['client_type'] ?? '') === (string) $typeOption['slug']) ? 'selected' : ''; ?>>
                                    <?= htmlspecialchars($typeOption['name'], ENT_QUOTES, 'UTF-8'); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
            <div>
                <label class="input-label" for="queue_id">Fila</label>
                <?php if ($isExternal): ?>
                    <input type="hidden" id="queue_id" name="queue_id" value="<?= (int) ($externalQueueId ?? 0); ?>">
                    <p class="muted">
                        <?= htmlspecialchars($externalQueueName, ENT_QUOTES, 'UTF-8'); ?>
                        (Fila dedicada para solicitações externas)
                    </p>
                    <?php if ($externalQueueId === null): ?>
                        <div class="alert alert--error" style="margin-top:0.5rem;">Fila padrão Central TI não encontrada. Contate o administrador.</div>
                    <?php endif; ?>
                <?php else: ?>
                    <select class="select-control" id="queue_id" name="queue_id" required>
                        <option value="">Selecione</option>
                        <?php foreach ($queues as $queue): ?>
                            <option value="<?= (int) $queue['id']; ?>" <?= ((int) ($ticket['queue_id'] ?? 0) === (int) $queue['id']) ? 'selected' : ''; ?>>
                                <?= htmlspecialchars($queue['name'], ENT_QUOTES, 'UTF-8'); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                <?php endif; ?>
            </div>
        </div>

        <div class="form-grid">
            <div>
                <label class="input-label" for="main_category">Categoria principal</label>
                <?php if ($mainCategories === []): ?>
                    <div class="alert alert--error" style="margin-top:0.5rem;">Nenhuma categoria principal ativa. Cadastre categorias raiz no módulo de Categorias.</div>
                <?php elseif ($isExternal): ?>
                    <input type="hidden" id="main_category" name="main_category" value="<?= htmlspecialchars($externalMainCategorySlug, ENT_QUOTES, 'UTF-8'); ?>">
                    <p class="muted"><?= htmlspecialchars($externalMainCategoryName, ENT_QUOTES, 'UTF-8'); ?> (definido automaticamente)</p>
                <?php else: ?>
                    <select class="select-control" id="main_category" name="main_category">
                        <?php foreach ($mainCategories as $mainCategory): ?>
                            <option value="<?= htmlspecialchars((string) $mainCategory['slug'], ENT_QUOTES, 'UTF-8'); ?>" <?= ((string) ($ticket['main_category'] ?? '') === (string) $mainCategory['slug']) ? 'selected' : ''; ?>>
                                <?= htmlspecialchars($mainCategory['name'], ENT_QUOTES, 'UTF-8'); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                <?php endif; ?>
            </div>
            <div>
                <label class="input-label" for="category_id">Subcategoria</label>
                <select class="select-control" id="category_id" name="category_id">
                    <option value="">Selecione</option>
                    <?php foreach ($categories as $category): ?>
                        <option
                            value="<?= (int) $category['id']; ?>"
                            data-queue="<?= (int) ($category['queue_id'] ?? 0); ?>"
                            <?= ((int) ($ticket['category_id'] ?? 0) === (int) $category['id']) ? 'selected' : ''; ?>>
                            <?= htmlspecialchars($category['name'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>

        <div>
            <label class="input-label" for="subject">Assunto</label>
            <input class="input-control" id="subject" name="subject" required value="<?= htmlspecialchars((string) ($ticket['subject'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>">
        </div>

        <div class="form-grid">
            <div>
                <label class="input-label" for="priority_id">Prioridade</label>
                <select class="select-control" id="priority_id" name="priority_id" required>
                    <option value="">Selecione</option>
                    <?php foreach ($priorities as $priority): ?>
                        <option value="<?= (int) $priority['id']; ?>" <?= ((int) ($ticket['priority_id'] ?? 0) === (int) $priority['id']) ? 'selected' : ''; ?>>
                            <?= htmlspecialchars($priority['name'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div>
                <label class="input-label" for="contact_name">Contato</label>
                <input class="input-control" id="contact_name" name="contact_name" value="<?= htmlspecialchars((string) ($ticket['contact_name'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>">
            </div>
        </div>

        <div class="form-grid">
            <div>
                <label class="input-label" for="contact_phone">Telefone</label>
                <input class="input-control" id="contact_phone" name="contact_phone" value="<?= htmlspecialchars((string) ($ticket['contact_phone'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div>
                <label class="input-label" for="contact_email">E-mail</label>
                <input class="input-control" id="contact_email" name="contact_email" value="<?= htmlspecialchars((string) ($ticket['contact_email'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>">
            </div>
        </div>

        <div class="form-grid">
            <div>
                <label class="input-label" for="assignee_id">Responsável</label>
                <?php if ($isExternal): ?>
                    <input type="hidden" id="assignee_id" name="assignee_id" value="<?= (int) ($externalAssigneeId ?? 0); ?>">
                    <p class="muted">
                        <?= htmlspecialchars($externalAssigneeName, ENT_QUOTES, 'UTF-8'); ?>
                        (responsável padrão)
                    </p>
                    <?php if ($externalAssigneeId === null): ?>
                        <div class="alert alert--error" style="margin-top:0.5rem;">Responsável padrão não encontrado. Contate o administrador.</div>
                    <?php endif; ?>
                <?php else: ?>
                    <select class="select-control" id="assignee_id" name="assignee_id">
                        <option value="">Não atribuído</option>
                        <?php foreach ($users as $userOption): ?>
                            <option value="<?= (int) $userOption['id']; ?>" <?= ((int) ($ticket['assignee_id'] ?? 0) === (int) $userOption['id']) ? 'selected' : ''; ?>>
                                <?= htmlspecialchars($userOption['name'], ENT_QUOTES, 'UTF-8'); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                <?php endif; ?>
            </div>
            <div aria-hidden="true"></div>
        </div>

        <div>
            <label class="input-label" for="customer_name">Cliente</label>
            <input class="input-control" id="customer_name" name="customer_name" value="<?= htmlspecialchars((string) ($ticket['customer_name'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>">
        </div>

        <div>
            <label class="input-label" for="description">Descrição</label>
            <textarea class="textarea-control" id="description" name="description" required><?= htmlspecialchars((string) ($ticket['description'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></textarea>
        </div>

        <div>
            <label class="input-label" for="status_id">Status</label>
            <select class="select-control" id="status_id" name="status_id" required>
                <?php foreach ($statuses as $status): ?>
                    <option value="<?= (int) $status['id']; ?>" <?= ((int) ($ticket['status_id'] ?? 0) === (int) $status['id']) ? 'selected' : ''; ?>>
                        <?= htmlspecialchars($status['name'], ENT_QUOTES, 'UTF-8'); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div>
            <label class="input-label" for="status_notes">Observação de status</label>
            <input class="input-control" id="status_notes" name="status_notes" placeholder="Motivo da alteração" value="">
        </div>

        <div class="card card--gradient dynamic-fields-card">
            <h2 class="card__title">Campos específicos da subcategoria</h2>
            <div class="dynamic-fields" data-dynamic-fields>
                <?= ticket_render_dynamic_fields($dynamicFieldCatalog[$currentCategoryId] ?? [], $fieldValues); ?>
            </div>
        </div>

        <div class="page__actions" style="margin-top:20px;">
            <button class="btn" type="submit"><?= $isEdit ? 'Salvar alterações' : 'Criar chamado'; ?></button>
        </div>
    </form>

    <?php if ($isEdit && \can('delete_ticket')): ?>
        <form class="card" method="post" action="<?= htmlspecialchars(app_url('tickets/delete'), ENT_QUOTES, 'UTF-8'); ?>" onsubmit="return confirm('Deseja remover este chamado?');" style="margin-top:1rem;">
            <?= csrf_input(); ?>
            <input type="hidden" name="id" value="<?= (int) $ticket['id']; ?>">
            <div class="page__actions">
                <button class="btn btn--outline" type="submit">Excluir chamado</button>
            </div>
        </form>
    <?php endif; ?>
</section>
<script>
window.ticketFieldCatalog = <?= json_encode($dynamicFieldCatalog, JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE); ?>;
window.ticketFieldInitialValues = <?= json_encode($fieldValues, JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE); ?>;
window.ticketInitialCategory = <?= $currentCategoryId; ?>;
</script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const catalog = window.ticketFieldCatalog || {};
    const container = document.querySelector('[data-dynamic-fields]');
    const select = document.getElementById('category_id');
    const queueSelect = document.getElementById('queue_id');
    if (!container || !select) {
        return;
    }

    const state = {};
    const initialCategory = parseInt(window.ticketInitialCategory || 0, 10) || 0;
    if (initialCategory && window.ticketFieldInitialValues) {
        state[initialCategory] = Object.assign({}, window.ticketFieldInitialValues);
    }

    let currentCategoryId = initialCategory;

    const escapeHtml = (value) => {
        return String(value)
            .replace(/&/g, '&amp;')
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;')
            .replace(/"/g, '&quot;')
            .replace(/'/g, '&#039;');
    };

    const buildFieldHtml = (field, value) => {
        const name = field.name;
        const id = `field-${name}`;
        const requiredMark = field.is_required ? ' <span style="color:var(--secondary);">*</span>' : '';
        const requiredAttr = field.is_required ? 'required' : '';
        let fieldHtml = `<div class="dynamic-field" data-field-wrapper>`;
        fieldHtml += `<label class="input-label" for="${escapeHtml(id)}">${escapeHtml(field.label)}${requiredMark}</label>`;

        if (field.type === 'textarea') {
            fieldHtml += `<textarea class="textarea-control" id="${escapeHtml(id)}" name="fields[${escapeHtml(name)}]" ${requiredAttr} data-field-name="${escapeHtml(name)}">${escapeHtml(value ?? '')}</textarea>`;
        } else if (field.type === 'select') {
            fieldHtml += `<select class="select-control" id="${escapeHtml(id)}" name="fields[${escapeHtml(name)}]" ${requiredAttr} data-field-name="${escapeHtml(name)}">`;
            fieldHtml += '<option value="">Selecione</option>';
            (field.options || []).forEach((option) => {
                const selected = option === value ? 'selected' : '';
                fieldHtml += `<option value="${escapeHtml(option)}" ${selected}>${escapeHtml(option)}</option>`;
            });
            fieldHtml += '</select>';
        } else if (field.type === 'number') {
            fieldHtml += `<input class="input-control" type="number" id="${escapeHtml(id)}" name="fields[${escapeHtml(name)}]" ${requiredAttr} value="${escapeHtml(value ?? '')}" data-field-name="${escapeHtml(name)}">`;
        } else if (field.type === 'boolean') {
            const checked = value === '1' ? 'checked' : '';
            fieldHtml += '<label class="checkbox-control">';
            fieldHtml += `<input type="hidden" name="fields[${escapeHtml(name)}]" value="0">`;
            fieldHtml += `<input type="checkbox" id="${escapeHtml(id)}" name="fields[${escapeHtml(name)}]" value="1" ${checked} data-field-name="${escapeHtml(name)}">`;
            fieldHtml += '<span>Sim</span>';
            fieldHtml += '</label>';
        } else {
            fieldHtml += `<input class="input-control" type="text" id="${escapeHtml(id)}" name="fields[${escapeHtml(name)}]" ${requiredAttr} value="${escapeHtml(value ?? '')}" data-field-name="${escapeHtml(name)}">`;
        }

        fieldHtml += '</div>';
        return fieldHtml;
    };

    const renderFields = (categoryId) => {
        currentCategoryId = categoryId;
        const fields = catalog[String(categoryId)] || [];
        if (fields.length === 0) {
            container.innerHTML = '<p class="muted">Selecione uma subcategoria para liberar campos específicos.</p>';
            return;
        }

        const values = state[categoryId] || {};
        const html = fields.map((field) => buildFieldHtml(field, values[field.name] ?? '')).join('');
        container.innerHTML = html;
    };

    const persistValue = (event) => {
        const target = event.target;
        if (!target || !target.dataset || !target.dataset.fieldName) {
            return;
        }

        if (!currentCategoryId) {
            return;
        }

        const fieldName = target.dataset.fieldName;
        if (!state[currentCategoryId]) {
            state[currentCategoryId] = {};
        }

        let value = target.value;
        if (target.type === 'checkbox') {
            value = target.checked ? '1' : '0';
        }

        state[currentCategoryId][fieldName] = value;
    };

    const applyQueueSuggestion = (option, onlyIfEmpty = false) => {
        if (!queueSelect || !option) {
            return;
        }

        const suggested = option.dataset && option.dataset.queue ? option.dataset.queue : null;
        if (!suggested || suggested === '0') {
            return;
        }

        if (onlyIfEmpty && queueSelect.value) {
            return;
        }

        queueSelect.value = suggested;
    };

    renderFields(initialCategory);
    const initialOption = select.options[select.selectedIndex];
    applyQueueSuggestion(initialOption, true);

    select.addEventListener('change', function () {
        const newCategory = parseInt(this.value || '0', 10) || 0;
        if (!state[newCategory]) {
            state[newCategory] = {};
        }
        renderFields(newCategory);
        const option = this.options[this.selectedIndex];
        applyQueueSuggestion(option);
    });

    container.addEventListener('input', persistValue);
    container.addEventListener('change', persistValue);
});
</script>
