<?php
$pageTitle = $pageTitle ?? 'Minha fila';
$scope = $scope ?? 'todos';
$summary = $summary ?? [];
$tickets = $tickets ?? [];
$queueName = $queueName ?? 'Fila';
$statusCounts = [];
foreach ($summary as $statusRow) {
    $slug = $statusRow['slug'] ?? '';
    $statusCounts[$slug] = (int) ($statusRow['total'] ?? 0);
}

$summaryBlocks = [
    ['slug' => 'novo', 'label' => 'Novos', 'accent' => 'badge--secondary'],
    ['slug' => 'em-triagem', 'label' => 'Em triagem', 'accent' => 'badge--neutral'],
    ['slug' => 'em-atendimento', 'label' => 'Em atendimento', 'accent' => 'badge--primary'],
    ['slug' => 'aguardando-cliente', 'label' => 'Aguardando cliente', 'accent' => 'badge--warning'],
];
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary">Fila do atendente</p>
            <h1 class="page__title"><?= htmlspecialchars($queueName, ENT_QUOTES, 'UTF-8'); ?></h1>
            <p class="page__subtitle">Visualize rapidamente os tickets da sua fila e priorize o atendimento.</p>
        </div>
        <div class="page__actions">
            <a class="btn btn--outline" href="<?= htmlspecialchars(app_url('tickets'), ENT_QUOTES, 'UTF-8'); ?>">Todos os chamados</a>
            <?php if (\can('create_ticket')): ?>
                <a class="btn" href="<?= htmlspecialchars(app_url('tickets/create'), ENT_QUOTES, 'UTF-8'); ?>">Abrir chamado</a>
            <?php endif; ?>
        </div>
    </div>

    <div class="card stats-grid">
        <?php foreach ($summaryBlocks as $block): ?>
            <?php $count = $statusCounts[$block['slug']] ?? 0; ?>
            <div class="stat-card">
                <span class="badge <?= $block['accent']; ?>"><?= htmlspecialchars($block['label'], ENT_QUOTES, 'UTF-8'); ?></span>
                <strong><?= $count; ?></strong>
                <small class="muted">Atualizado agora</small>
            </div>
        <?php endforeach; ?>
    </div>

    <div class="card card--tabs">
        <div class="tabs">
            <?php
                $scopes = [
                    'todos' => 'Todos',
                    'meus' => 'Meus atribuídos',
                    'livres' => 'Sem responsável',
                ];
            ?>
            <?php foreach ($scopes as $slug => $label): ?>
                <a class="tab <?= $scope === $slug ? 'tab--active' : ''; ?>" href="<?= htmlspecialchars(app_url('tickets/minha-fila?scope=' . $slug), ENT_QUOTES, 'UTF-8'); ?>">
                    <?= htmlspecialchars($label, ENT_QUOTES, 'UTF-8'); ?>
                </a>
            <?php endforeach; ?>
        </div>
        <div class="tab-content">
            <div style="overflow-x:auto;">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Ref</th>
                            <th>Assunto</th>
                            <th>Status</th>
                            <th>Responsável</th>
                            <th>SLA</th>
                            <th>Atualizado</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($tickets as $ticket): ?>
                        <?php $isEmergencyRow = !empty($ticket['is_emergency']); ?>
                        <tr class="<?= $isEmergencyRow ? 'ticket-row ticket-row--emergency' : 'ticket-row'; ?>">
                            <td><?= htmlspecialchars($ticket['reference'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td>
                                <strong><?= htmlspecialchars($ticket['subject'], ENT_QUOTES, 'UTF-8'); ?></strong><br>
                                <span class="muted"><?= htmlspecialchars($ticket['requester_name'], ENT_QUOTES, 'UTF-8'); ?></span>
                                <?php if ($isEmergencyRow): ?>
                                    <span class="badge badge--danger badge--pulse">Emergência</span>
                                <?php endif; ?>
                            </td>
                            <td><span class="badge badge--secondary"><?= htmlspecialchars($ticket['status_name'], ENT_QUOTES, 'UTF-8'); ?></span></td>
                            <td>
                                <?php if (!empty($ticket['assignee_name'])): ?>
                                    <?= htmlspecialchars($ticket['assignee_name'], ENT_QUOTES, 'UTF-8'); ?>
                                <?php else: ?>
                                    <span class="badge badge--warning">Sem responsável</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php $slaData = $ticket['sla']['response'] ?? null; ?>
                                <?php if ($slaData && ($slaData['target'] ?? 0) > 0): ?>
                                    <?php
                                        $slaStatus = $slaData['status'] ?? 'pending';
                                        $isLate = $slaStatus === 'late';
                                        $badgeClass = $isLate ? 'badge badge--danger' : 'badge badge--success';
                                        $badgeText = $isLate ? 'Estourado' : 'No prazo';
                                    ?>
                                    <div class="sla-badge">
                                        <span class="<?= $badgeClass; ?>"><?= $badgeText; ?></span>
                                        <small class="muted"><?= htmlspecialchars(human_minutes($slaData['elapsed'] ?? 0), ENT_QUOTES, 'UTF-8'); ?></small>
                                    </div>
                                <?php else: ?>
                                    <span class="badge badge--neutral">Sem SLA</span>
                                <?php endif; ?>
                            </td>
                            <td><?= htmlspecialchars(date('d/m H:i', strtotime($ticket['updated_at'])), ENT_QUOTES, 'UTF-8'); ?></td>
                            <td>
                                <a class="btn btn--outline" href="<?= htmlspecialchars(app_url('tickets/show?id=' . $ticket['id']), ENT_QUOTES, 'UTF-8'); ?>">Detalhes</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (empty($tickets)): ?>
                        <tr>
                            <td colspan="7" style="text-align:center;padding:1.5rem;">Nenhum chamado encontrado para este filtro.</td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>
