<?php
$pageTitle = $pageTitle ?? 'Chamado';
$flashSuccess = $flash['success'] ?? null;
$flashError = $flash['error'] ?? null;
$commentErrors = $commentErrors ?? [];
$commentOld = $commentOld ?? [];
$emergencyErrors = $emergencyErrors ?? [];
$emergencyOld = $emergencyOld ?? [];
$emergencyActions = $emergencyActions ?? [];
$isEmergency = $isEmergency ?? false;
$dynamicFields = $dynamicFields ?? [];
$slaData = $sla ?? null;
$emergencyAudio = $isEmergency ? asset_url('assets/audio/emergency-alert.wav') : null;
?>
<section class="page">
    <div class="page__header">
        <div>
            <p class="badge badge--primary"><?= htmlspecialchars($ticket['reference'], ENT_QUOTES, 'UTF-8'); ?></p>
            <h1 class="page__title"><?= htmlspecialchars($ticket['subject'], ENT_QUOTES, 'UTF-8'); ?></h1>
            <p class="page__subtitle"><?= htmlspecialchars($ticket['queue_name'], ENT_QUOTES, 'UTF-8'); ?> &middot; <?= htmlspecialchars($ticket['priority_name'], ENT_QUOTES, 'UTF-8'); ?></p>
        </div>
        <div class="page__actions">
            <a class="btn btn--outline" href="<?= htmlspecialchars(app_url('tickets'), ENT_QUOTES, 'UTF-8'); ?>">Voltar</a>
            <?php if (\can('update_ticket')): ?>
                <a class="btn" href="<?= htmlspecialchars(app_url('tickets/edit?id=' . $ticket['id']), ENT_QUOTES, 'UTF-8'); ?>">Editar</a>
            <?php endif; ?>
        </div>
    </div>

    <?php if ($flashSuccess): ?>
        <div class="alert alert--info" style="background: rgba(33, 150, 83, 0.12); color:#1b5e20; border:1px solid rgba(33,150,83,0.3);">
            <?= htmlspecialchars($flashSuccess, ENT_QUOTES, 'UTF-8'); ?>
        </div>
    <?php endif; ?>
    <?php if ($flashError): ?>
        <div class="alert alert--error"><?= htmlspecialchars($flashError, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>

    <?php if ($isEmergency): ?>
        <div class="emergency-banner">
            <div class="emergency-banner__info">
                <div class="emergency-banner__icon" aria-hidden="true">🚨</div>
                <div>
                    <p class="badge badge--danger">Modo Emergência NOC</p>
                    <h2>Atendimento crítico em andamento</h2>
                    <p>Categoria <?= htmlspecialchars($ticket['category_name'] ?? 'NOC', ENT_QUOTES, 'UTF-8'); ?></p>
                    <div class="emergency-tags">
                        <span class="badge badge--secondary"><?= htmlspecialchars($ticket['priority_name'], ENT_QUOTES, 'UTF-8'); ?></span>
                        <span class="badge badge--primary"><?= htmlspecialchars($ticket['queue_name'], ENT_QUOTES, 'UTF-8'); ?></span>
                        <?php if (!empty($ticket['contact_phone'])): ?>
                            <span class="badge badge--neutral">Contato <?= htmlspecialchars($ticket['contact_phone'], ENT_QUOTES, 'UTF-8'); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="emergency-banner__actions">
                <?php if ($emergencyAudio): ?>
                    <audio data-emergency-audio loop preload="auto" playsinline>
                        <source src="<?= htmlspecialchars($emergencyAudio, ENT_QUOTES, 'UTF-8'); ?>" type="audio/wav">
                    </audio>
                    <button class="btn btn--ghost emergency-audio" data-emergency-audio-toggle type="button">Ativar alerta sonoro</button>
                    <small class="muted" data-emergency-audio-status>Alerta sonoro inativo.</small>
                <?php endif; ?>
                <div class="emergency-banner__legend">
                    <strong>Fluxo rápido:</strong>
                    <span>Evento → Ação → Contato → Acionamento → Conclusão</span>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="responsive-stack">
        <div class="card">
            <h2 class="card__title">Informações gerais</h2>
            <div class="details-grid">
                <div>
                    <span class="input-label">Status</span>
                    <p><span class="badge badge--secondary"><?= htmlspecialchars($ticket['status_name'], ENT_QUOTES, 'UTF-8'); ?></span></p>
                </div>
                <div>
                    <span class="input-label">Tipo</span>
                    <p><?= htmlspecialchars(strtoupper($ticket['client_type']), ENT_QUOTES, 'UTF-8'); ?></p>
                </div>
                <div>
                    <span class="input-label">Categoria</span>
                    <p><?= htmlspecialchars(strtoupper($ticket['main_category']), ENT_QUOTES, 'UTF-8'); ?></p>
                </div>
                <div>
                    <span class="input-label">Subcategoria</span>
                    <p><?= htmlspecialchars($ticket['category_name'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></p>
                </div>
                <div>
                    <span class="input-label">Solicitante</span>
                    <p><?= htmlspecialchars($ticket['requester_name'], ENT_QUOTES, 'UTF-8'); ?></p>
                </div>
                <div>
                    <span class="input-label">Responsável</span>
                    <p><?= htmlspecialchars($ticket['assignee_name'] ?? 'Não atribuído', ENT_QUOTES, 'UTF-8'); ?></p>
                </div>
            </div>
        </div>

        <div class="card">
            <h2 class="card__title">Contato</h2>
            <div class="details-grid">
                <div>
                    <span class="input-label">Nome</span>
                    <p><?= htmlspecialchars($ticket['contact_name'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></p>
                </div>
                <div>
                    <span class="input-label">Telefone</span>
                    <p><?= htmlspecialchars($ticket['contact_phone'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></p>
                </div>
                <div>
                    <span class="input-label">E-mail</span>
                    <p><?= htmlspecialchars($ticket['contact_email'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></p>
                </div>
                <div>
                    <span class="input-label">Cliente</span>
                    <p><?= htmlspecialchars($ticket['customer_name'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></p>
                </div>
            </div>
        </div>
    </div>

    <?php if ($isEmergency): ?>
        <div class="card emergency-panel">
            <div class="emergency-panel__column">
                <h2 class="card__title">Registro rápido de acionamento</h2>
                <p class="muted">Informe rapidamente quem foi acionado, horário e protocolo para manter a torre atualizada.</p>
                <?php if (!empty($emergencyErrors)): ?>
                    <div class="alert alert--error">
                        <?php foreach ($emergencyErrors as $error): ?>
                            <div><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <?php if (\can('update_ticket')): ?>
                    <form method="post" action="<?= htmlspecialchars(app_url('tickets/emergency-log'), ENT_QUOTES, 'UTF-8'); ?>" class="emergency-form">
                        <input type="hidden" name="ticket_id" value="<?= (int) $ticket['id']; ?>">
                        <div class="form-grid">
                            <div>
                                <label class="input-label" for="action_type">Tipo de ação</label>
                                <?php $actionTypeOld = $emergencyOld['action_type'] ?? 'acionamento'; ?>
                                <select class="select-control" id="action_type" name="action_type">
                                    <option value="alerta" <?= $actionTypeOld === 'alerta' ? 'selected' : ''; ?>>Alerta inicial</option>
                                    <option value="contato" <?= $actionTypeOld === 'contato' ? 'selected' : ''; ?>>Contato crítico</option>
                                    <option value="acionamento" <?= $actionTypeOld === 'acionamento' ? 'selected' : ''; ?>>Acionamento autoridade</option>
                                    <option value="conclusao" <?= $actionTypeOld === 'conclusao' ? 'selected' : ''; ?>>Conclusão/estabilização</option>
                                </select>
                            </div>
                            <div>
                                <label class="input-label" for="authority">Autoridade</label>
                                <input class="input-control" id="authority" name="authority" list="authority-options" placeholder="Polícia, SAMU, Bombeiros..." value="<?= htmlspecialchars((string) ($emergencyOld['authority'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>" required>
                                <datalist id="authority-options">
                                    <option value="Polícia Militar"></option>
                                    <option value="SAMU"></option>
                                    <option value="Bombeiros"></option>
                                    <option value="Defesa Civil"></option>
                                    <option value="Guarda Municipal"></option>
                                </datalist>
                            </div>
                        </div>
                        <div class="form-grid">
                            <div>
                                <label class="input-label" for="contact_name">Contato responsável</label>
                                <input class="input-control" id="contact_name" name="contact_name" value="<?= htmlspecialchars((string) ($emergencyOld['contact_name'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>">
                            </div>
                            <div>
                                <label class="input-label" for="contact_phone">Telefone</label>
                                <input class="input-control" id="contact_phone" name="contact_phone" value="<?= htmlspecialchars((string) ($emergencyOld['contact_phone'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>">
                            </div>
                            <div>
                                <label class="input-label" for="protocol_code">Protocolo</label>
                                <input class="input-control" id="protocol_code" name="protocol_code" value="<?= htmlspecialchars((string) ($emergencyOld['protocol_code'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>">
                            </div>
                        </div>
                        <div class="form-grid">
                            <div>
                                <label class="input-label" for="occurred_at">Horário</label>
                                <?php
                                    $occurred = $emergencyOld['occurred_at'] ?? date('Y-m-d\\TH:i');
                                ?>
                                <input class="input-control" type="datetime-local" id="occurred_at" name="occurred_at" value="<?= htmlspecialchars((string) $occurred, ENT_QUOTES, 'UTF-8'); ?>" required>
                            </div>
                            <div>
                                <label class="input-label" for="notes">Notas adicionais</label>
                                <input class="input-control" id="notes" name="notes" placeholder="Resumo do acionamento" value="<?= htmlspecialchars((string) ($emergencyOld['notes'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>">
                            </div>
                        </div>
                        <div class="page__actions" style="justify-content:flex-start;">
                            <button class="btn" type="submit">Registrar acionamento</button>
                        </div>
                    </form>
                <?php else: ?>
                    <p class="muted">Somente a equipe NOC pode registrar novos acionamentos.</p>
                <?php endif; ?>
            </div>
            <div class="emergency-panel__column emergency-panel__history">
                <h3>Histórico de acionamentos</h3>
                <p class="muted">Cada registro gera um evento auditável na timeline abaixo.</p>
                <div class="emergency-log__list">
                    <?php foreach ($emergencyActions as $action): ?>
                        <div class="emergency-log__item">
                            <div class="emergency-log__header">
                                <strong><?= htmlspecialchars(strtoupper($action['authority'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></strong>
                                <span><?= htmlspecialchars(date('d/m H:i', strtotime((string) ($action['occurred_at'] ?? $action['created_at'] ?? 'now'))), ENT_QUOTES, 'UTF-8'); ?></span>
                            </div>
                            <p class="muted"><?= htmlspecialchars(ucfirst($action['action_type'] ?? 'acionamento'), ENT_QUOTES, 'UTF-8'); ?> &middot; <?= htmlspecialchars($action['created_by_name'] ?? 'NOC', ENT_QUOTES, 'UTF-8'); ?></p>
                            <ul class="emergency-log__details">
                                <?php if (!empty($action['protocol_code'])): ?>
                                    <li>Protocolo <?= htmlspecialchars($action['protocol_code'], ENT_QUOTES, 'UTF-8'); ?></li>
                                <?php endif; ?>
                                <?php if (!empty($action['contact_name'])): ?>
                                    <li>Contato <?= htmlspecialchars($action['contact_name'], ENT_QUOTES, 'UTF-8'); ?></li>
                                <?php endif; ?>
                                <?php if (!empty($action['contact_phone'])): ?>
                                    <li>Fone <?= htmlspecialchars($action['contact_phone'], ENT_QUOTES, 'UTF-8'); ?></li>
                                <?php endif; ?>
                            </ul>
                            <?php if (!empty($action['notes'])): ?>
                                <p><?= htmlspecialchars($action['notes'], ENT_QUOTES, 'UTF-8'); ?></p>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                    <?php if (empty($emergencyActions)): ?>
                        <p class="muted">Nenhum acionamento registrado ainda. Use o formulário ao lado para iniciar.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if (!empty($dynamicFields)): ?>
        <div class="card">
            <h2 class="card__title">Campos específicos</h2>
            <div class="details-grid">
                <?php foreach ($dynamicFields as $field): ?>
                    <div>
                        <span class="input-label"><?= htmlspecialchars($field['label'], ENT_QUOTES, 'UTF-8'); ?></span>
                        <?php $fieldValue = trim((string) ($field['value'] ?? '')); ?>
                        <p><?= $fieldValue !== '' ? nl2br(htmlspecialchars($fieldValue, ENT_QUOTES, 'UTF-8')) : '-'; ?></p>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>

    <?php if ($slaData): ?>
        <?php
        $responseSla = $slaData['response'] ?? null;
        $resolutionSla = $slaData['resolution'] ?? null;
        $responseTarget = $responseSla['target'] ?? 0;
        $resolutionTarget = $resolutionSla['target'] ?? 0;
        ?>
        <div class="card">
            <h2 class="card__title">Acompanhamento de SLA</h2>
            <div class="sla-grid">
                <div class="sla-item">
                    <span class="input-label">Primeira resposta</span>
                    <?php if ($responseTarget > 0): ?>
                        <?php
                        $status = $responseSla['status'] ?? 'pending';
                        $badgeClass = $status === 'late' ? 'badge badge--danger' : 'badge badge--success';
                        $badgeText = $status === 'late' ? 'Estourado' : 'No prazo';
                        ?>
                        <div class="sla-item__status">
                            <span class="<?= $badgeClass; ?>"><?= $badgeText; ?></span>
                            <small class="muted">
                                Meta <?= htmlspecialchars(human_minutes($responseTarget), ENT_QUOTES, 'UTF-8'); ?>
                                &middot;
                                <?= ($responseSla['achieved_at'] ?? null)
                                    ? 'Real ' . htmlspecialchars(human_minutes($responseSla['elapsed'] ?? 0), ENT_QUOTES, 'UTF-8')
                                    : 'Em andamento (' . htmlspecialchars(human_minutes($responseSla['elapsed'] ?? 0), ENT_QUOTES, 'UTF-8') . ')' ?>
                            </small>
                        </div>
                    <?php else: ?>
                        <p class="muted">Sem política configurada para este cenário.</p>
                    <?php endif; ?>
                </div>
                <div class="sla-item">
                    <span class="input-label">Resolução</span>
                    <?php if ($resolutionTarget > 0): ?>
                        <?php
                        $status = $resolutionSla['status'] ?? 'pending';
                        $badgeClass = $status === 'late' ? 'badge badge--danger' : 'badge badge--success';
                        $badgeText = $status === 'late' ? 'Estourado' : 'No prazo';
                        ?>
                        <div class="sla-item__status">
                            <span class="<?= $badgeClass; ?>"><?= $badgeText; ?></span>
                            <small class="muted">
                                Meta <?= htmlspecialchars(human_minutes($resolutionTarget), ENT_QUOTES, 'UTF-8'); ?>
                                &middot;
                                <?php if ($resolutionSla['completed_at'] ?? null): ?>
                                    Real <?= htmlspecialchars(human_minutes($resolutionSla['elapsed'] ?? 0), ENT_QUOTES, 'UTF-8'); ?>
                                <?php elseif (($resolutionSla['status'] ?? '') === 'pending'): ?>
                                    <?= htmlspecialchars(human_minutes(max(0, ($resolutionSla['target'] ?? 0) - ($resolutionSla['elapsed'] ?? 0))), ENT_QUOTES, 'UTF-8'); ?> restante
                                <?php else: ?>
                                    Atual <?= htmlspecialchars(human_minutes($resolutionSla['elapsed'] ?? 0), ENT_QUOTES, 'UTF-8'); ?>
                                <?php endif; ?>
                            </small>
                        </div>
                    <?php else: ?>
                        <p class="muted">Sem política configurada para este cenário.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="card">
        <h2 class="card__title">Descrição</h2>
        <p><?= nl2br(htmlspecialchars($ticket['description'], ENT_QUOTES, 'UTF-8')); ?></p>
    </div>

    <div class="card card--elevated">
        <h2 class="card__title">Timeline</h2>
        <div class="timeline">
            <?php foreach ($timeline as $event): ?>
                <?php
                    $timestamp = $event['timestamp'] ?? null;
                    $formattedDate = $timestamp ? date('d/m/Y H:i', strtotime($timestamp)) : '';
                ?>
                <?php if (($event['type'] ?? '') === 'comment'): ?>
                    <div class="timeline__item timeline__item--comment">
                        <div class="timeline__indicator timeline__indicator--comment"></div>
                        <div class="comment-card">
                            <div class="comment-card__header">
                                <div>
                                    <strong><?= htmlspecialchars($event['author'] ?? 'Usuário', ENT_QUOTES, 'UTF-8'); ?></strong>
                                    <p class="comment-card__meta"><?= htmlspecialchars($formattedDate, ENT_QUOTES, 'UTF-8'); ?></p>
                                </div>
                                <div class="comment-card__tags">
                                    <span class="badge badge--neutral">Comentário</span>
                                    <?php if (!empty($event['is_internal'])): ?>
                                        <span class="badge badge--secondary">Privado</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php if (!empty($event['content'])): ?>
                                <p><?= nl2br(htmlspecialchars((string) $event['content'], ENT_QUOTES, 'UTF-8')); ?></p>
                            <?php endif; ?>
                            <?php if (!empty($event['attachments'])): ?>
                                <div class="attachment-list">
                                    <?php foreach ($event['attachments'] as $attachment): ?>
                                        <?php
                                            $downloadUrl = app_url('attachments/download?id=' . $attachment['id']);
                                            $previewUrl = app_url('attachments/download?id=' . $attachment['id'] . '&inline=1');
                                        ?>
                                        <div class="attachment-card">
                                            <div>
                                                <strong><?= htmlspecialchars($attachment['filename'], ENT_QUOTES, 'UTF-8'); ?></strong>
                                                <p class="comment-card__meta"><?= htmlspecialchars($attachment['size_label'] ?? '', ENT_QUOTES, 'UTF-8'); ?></p>
                                            </div>
                                            <div class="attachment-card__actions">
                                                <a href="<?= htmlspecialchars($downloadUrl, ENT_QUOTES, 'UTF-8'); ?>">Baixar</a>
                                                <?php if (!empty($attachment['is_previewable'])): ?>
                                                    <a href="<?= htmlspecialchars($previewUrl, ENT_QUOTES, 'UTF-8'); ?>" target="_blank" rel="noopener">Preview</a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php elseif (($event['type'] ?? '') === 'emergency'): ?>
                    <div class="timeline__item timeline__item--emergency">
                        <div class="timeline__indicator timeline__indicator--emergency" aria-hidden="true">⚡</div>
                        <div>
                            <strong>Acionamento <?= htmlspecialchars(strtoupper($event['authority'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></strong>
                            <p class="muted">
                                <?= htmlspecialchars($formattedDate, ENT_QUOTES, 'UTF-8'); ?>
                                &middot;
                                <?= htmlspecialchars($event['author'] ?? 'NOC', ENT_QUOTES, 'UTF-8'); ?>
                            </p>
                            <div class="emergency-pill">
                                <span><?= htmlspecialchars(ucfirst($event['action_type'] ?? 'ação'), ENT_QUOTES, 'UTF-8'); ?></span>
                                <?php if (!empty($event['protocol_code'])): ?>
                                    <span>Protocolo <?= htmlspecialchars($event['protocol_code'], ENT_QUOTES, 'UTF-8'); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($event['contact_name'])): ?>
                                    <span>Contato <?= htmlspecialchars($event['contact_name'], ENT_QUOTES, 'UTF-8'); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($event['contact_phone'])): ?>
                                    <span>Fone <?= htmlspecialchars($event['contact_phone'], ENT_QUOTES, 'UTF-8'); ?></span>
                                <?php endif; ?>
                            </div>
                            <?php if (!empty($event['notes'])): ?>
                                <p><?= htmlspecialchars($event['notes'], ENT_QUOTES, 'UTF-8'); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="timeline__item">
                        <div class="timeline__indicator"></div>
                        <div>
                            <strong><?= htmlspecialchars($event['to_status'] ?? 'Status', ENT_QUOTES, 'UTF-8'); ?></strong>
                            <p class="muted">
                                <?= htmlspecialchars($formattedDate, ENT_QUOTES, 'UTF-8'); ?>
                                &middot;
                                <?= htmlspecialchars($event['author'] ?? 'Sistema', ENT_QUOTES, 'UTF-8'); ?>
                            </p>
                            <?php if (!empty($event['notes'])): ?>
                                <p><?= htmlspecialchars($event['notes'], ENT_QUOTES, 'UTF-8'); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
            <?php if (empty($timeline)): ?>
                <p>Nenhum evento registrado.</p>
            <?php endif; ?>
        </div>

        <div class="comment-form">
            <h3>Adicionar interação</h3>
            <?php if (!empty($commentErrors)): ?>
                <div class="alert alert--error">
                    <?php foreach ($commentErrors as $message): ?>
                        <div><?= htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?></div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <form method="post" action="<?= htmlspecialchars(app_url('tickets/comment'), ENT_QUOTES, 'UTF-8'); ?>" enctype="multipart/form-data">
                <input type="hidden" name="ticket_id" value="<?= (int) $ticket['id']; ?>">
                <div>
                    <label class="input-label" for="comment-content">Comentário</label>
                    <textarea class="textarea-control" id="comment-content" name="content" rows="4" placeholder="Descreva o avanço, pendências ou comunique o solicitante."><?= htmlspecialchars((string) ($commentOld['content'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></textarea>
                </div>
                <div class="comment-form__upload">
                    <label class="input-label" for="comment-attachments">Anexos</label>
                    <input class="input-control" type="file" id="comment-attachments" name="attachments[]" multiple accept="image/*,application/pdf,video/*">
                    <small class="muted">Formatos aceitos: imagens, PDF e vídeos (até 20MB cada).</small>
                </div>
                <?php if (\can('update_ticket')): ?>
                    <label class="checkbox-control">
                        <input type="checkbox" name="is_internal" value="1" <?= !empty($commentOld['is_internal']) ? 'checked' : ''; ?>>
                        <span>Marcar como nota interna (visível apenas para equipe)</span>
                    </label>
                <?php endif; ?>
                <div class="page__actions" style="justify-content:flex-start;">
                    <button class="btn" type="submit">Registrar atualização</button>
                </div>
            </form>
        </div>
    </div>
</section>
<?php if ($isEmergency && $emergencyAudio): ?>
    <script src="<?= htmlspecialchars(asset_url('assets/js/emergency-audio.js'), ENT_QUOTES, 'UTF-8'); ?>" defer></script>
<?php endif; ?>
